/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.Field;
import swim.math.TensorArray;
import swim.math.TensorArraySpace;
import swim.math.TensorDims;
import swim.math.TensorSpace;

final class TensorArrayObjectSpace<V, S>
extends TensorArraySpace<TensorArray<V, S>, V, S>
implements Debug {
    final TensorSpace<V, S> next;
    final TensorDims dims;

    TensorArrayObjectSpace(TensorSpace<V, S> next, TensorDims dims) {
        this.next = next;
        this.dims = dims;
    }

    @Override
    public Field<S> scalar() {
        return this.next.scalar();
    }

    @Override
    public TensorDims dimensions() {
        return this.dims;
    }

    @Override
    public TensorSpace<V, S> next() {
        return this.next;
    }

    @Override
    public TensorArray<V, S> of(Object ... array) {
        return new TensorArray(this, array);
    }

    @Override
    public Object[] toArray(TensorArray<V, S> tensor) {
        return tensor.array;
    }

    public void debug(Output<?> output) {
        output.write("TensorArray").write(46).write("space").write(40).debug(this.next).write(", ").debug((Object)this.dims).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

