/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.TensorForm;
import swim.math.VectorR3;
import swim.math.VectorZ3Form;
import swim.math.Z3ToR3Function;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class VectorZ3
implements Debug {
    public final long x;
    public final long y;
    public final long z;
    private static int hashSeed;
    private static VectorZ3 zero;
    private static TensorForm<VectorZ3> form;

    public VectorZ3(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final VectorZ3 plus(VectorZ3 that) {
        return new VectorZ3(this.x + that.x, this.y + that.y, this.z + that.z);
    }

    public final VectorZ3 opposite() {
        return new VectorZ3(-this.x, -this.y, -this.z);
    }

    public final VectorZ3 minus(VectorZ3 that) {
        return new VectorZ3(this.x - that.x, this.y - that.y, this.z - that.z);
    }

    public final VectorZ3 times(long scalar) {
        return new VectorZ3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public VectorR3 transform(Z3ToR3Function f) {
        return new VectorR3(f.transformX(this.x, this.y, this.z), f.transformY(this.x, this.y, this.z), f.transformZ(this.x, this.y, this.z));
    }

    public Value toValue() {
        return VectorZ3.form().mold(this).toValue();
    }

    protected boolean canEqual(VectorZ3 that) {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof VectorZ3) {
            VectorZ3 that = (VectorZ3)other;
            return that.canEqual(this) && this.x == that.x && this.y == that.y && this.z == that.z;
        }
        return false;
    }

    public int hashCode() {
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)1119353823, (int)Murmur3.hash((long)this.x)), (int)Murmur3.hash((long)this.y)), (int)Murmur3.hash((long)this.z)));
    }

    public void debug(Output<?> output) {
        output.write("VectorZ3").write(46).write("of").write(40).debug((Object)this.x).write(", ").debug((Object)this.y).write(", ").debug((Object)this.z).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static VectorZ3 zero() {
        if (zero == null) {
            zero = new VectorZ3(0L, 0L, 0L);
        }
        return zero;
    }

    public static VectorZ3 of(long x, long y, long z) {
        return new VectorZ3(x, y, z);
    }

    @Kind
    public static TensorForm<VectorZ3> form() {
        if (form == null) {
            form = new VectorZ3Form();
        }
        return form;
    }
}

