/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LinkAddressed;
import swim.warp.LinkedResponseForm;

public final class LinkedResponse
extends LinkAddressed {
    @Kind
    public static final Form<LinkedResponse> FORM = new LinkedResponseForm();

    public LinkedResponse(Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(nodeUri, laneUri, prio, rate, body);
    }

    public LinkedResponse(Uri nodeUri, Uri laneUri, float prio, float rate) {
        this(nodeUri, laneUri, prio, rate, Value.absent());
    }

    public LinkedResponse(Uri nodeUri, Uri laneUri, Value body) {
        this(nodeUri, laneUri, 0.0f, 0.0f, body);
    }

    public LinkedResponse(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, 0.0f, 0.0f, Value.absent());
    }

    public LinkedResponse(String nodeUri, String laneUri, float prio, float rate, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, body);
    }

    public LinkedResponse(String nodeUri, String laneUri, float prio, float rate) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, Value.absent());
    }

    public LinkedResponse(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, body);
    }

    public LinkedResponse(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, Value.absent());
    }

    @Override
    public String tag() {
        return "linked";
    }

    public Form<LinkedResponse> form() {
        return FORM;
    }

    @Override
    public LinkedResponse nodeUri(Uri nodeUri) {
        return new LinkedResponse(nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public LinkedResponse laneUri(Uri laneUri) {
        return new LinkedResponse(this.nodeUri, laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public LinkedResponse body(Value body) {
        return new LinkedResponse(this.nodeUri, this.laneUri, this.prio, this.rate, body);
    }
}

