/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet.combinator;

import java.util.Iterator;
import java.util.Map;
import swim.collections.HashTrieMap;
import swim.streamlet.AbstractMapInletMapOutlet;
import swim.streamlet.KeyEffect;
import swim.util.Cursor;

public abstract class FilterFieldsOperator<K, V, I>
extends AbstractMapInletMapOutlet<K, K, V, V, I, Map<K, V>> {
    @Override
    public boolean containsKey(K key) {
        if (this.input != null) {
            Object value = this.input.get(key);
            return value != null && this.evaluate(key, value);
        }
        return false;
    }

    @Override
    public V get(K key) {
        Object value;
        if (this.input != null && (value = this.input.get(key)) != null && this.evaluate(key, value)) {
            return value;
        }
        return null;
    }

    @Override
    public Map<K, V> get() {
        HashTrieMap output = HashTrieMap.empty();
        Iterator<K> keys = this.keyIterator();
        while (keys.hasNext()) {
            K key = keys.next();
            Object value = this.input.get(key);
            if (value == null || !this.evaluate(key, value)) continue;
            output = output.updated(key, value);
        }
        return output;
    }

    @Override
    public Iterator<K> keyIterator() {
        if (this.input != null) {
            return this.input.keyIterator();
        }
        return Cursor.empty();
    }

    @Override
    protected void onInvalidateOutputKey(K key, KeyEffect effect) {
        this.invalidateInputKey(key, effect);
    }

    @Override
    protected void onReconcileOutputKey(K key, KeyEffect effect, int version) {
        this.reconcileInputKey(key, version);
    }

    @Override
    protected KeyEffect willReconcileInputKey(K key, KeyEffect effect, int version) {
        Object value;
        if (!(effect != KeyEffect.UPDATE || this.input == null || (value = this.input.get(key)) != null && this.evaluate(key, value))) {
            return KeyEffect.REMOVE;
        }
        return effect;
    }

    public abstract boolean evaluate(K var1, V var2);
}

