/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class LambdaFuncWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final V bindings;
    final V template;
    final Writer<?, ?> part;
    final int step;

    LambdaFuncWriter(ReconWriter<I, V> recon, V bindings, V template, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.bindings = bindings;
        this.template = template;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return LambdaFuncWriter.write(output, this.recon, this.bindings, this.template, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, V bindings, V template) {
        int size = 0;
        size += recon.sizeOfPrimary(bindings);
        size += 4;
        return size += recon.sizeOfValue(template);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V bindings, V template, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? recon.writePrimary(bindings, output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(32);
            step = 3;
        }
        if (step == 3 && output.isCont()) {
            output = output.write(61);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(62);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(32);
            step = 6;
        }
        if (step == 6) {
            if ((part = part == null ? recon.writeValue(template, output) : part.pull(output)).isDone()) {
                return LambdaFuncWriter.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return LambdaFuncWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return LambdaFuncWriter.error((Throwable)output.trap());
        }
        return new LambdaFuncWriter<I, V>(recon, bindings, template, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V bindings, V template) {
        return LambdaFuncWriter.write(output, recon, bindings, template, null, 1);
    }
}

