/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.json.Json;
import swim.json.JsonParser;

final class IdentParser<I, V>
extends Parser<V> {
    final JsonParser<I, V> json;
    final Output<V> output;
    final int step;

    IdentParser(JsonParser<I, V> json, Output<V> output, int step) {
        this.json = json;
        this.output = output;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return IdentParser.parse(input, this.json, this.output, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Output<V> output, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Json.isIdentStartChar(c)) return IdentParser.error((Diagnostic)Diagnostic.expected((String)"identifier", (Input)input));
                input = input.step();
                if (output == null) {
                    output = json.textOutput();
                }
                output = output.write(c);
                step = 2;
            } else if (input.isDone()) {
                return IdentParser.error((Diagnostic)Diagnostic.expected((String)"identifier", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Json.isIdentChar(c = input.head())) {
                input = input.step();
                output = output.write(c);
            }
            if (!input.isEmpty()) {
                return IdentParser.done((Object)json.ident(output.bind()));
            }
        }
        if (!input.isError()) return new IdentParser<I, Object>(json, output, step);
        return IdentParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json, Output<V> output) {
        return IdentParser.parse(input, json, output, 1);
    }

    static <I, V> Parser<V> parse(Input input, JsonParser<I, V> json) {
        return IdentParser.parse(input, json, null, 1);
    }
}

