/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentTrancheQueue<T> {
    final ConcurrentLinkedQueue<T>[] queues;
    final float scale;
    final int highest;

    public ConcurrentTrancheQueue(int tranches) {
        if (tranches == 0) {
            throw new IllegalArgumentException();
        }
        this.queues = new ConcurrentLinkedQueue[tranches];
        for (int i = 0; i < tranches; ++i) {
            this.queues[i] = new ConcurrentLinkedQueue();
        }
        this.scale = 0.5f * (float)tranches;
        this.highest = tranches - 1;
    }

    public void add(T value, float prio) {
        int tranche = Math.max(0, Math.min((int)((1.0f + prio) * this.scale), this.highest));
        this.queues[tranche].add(value);
    }

    public T peek() {
        for (int tranche = this.highest; tranche >= 0; --tranche) {
            T value = this.queues[tranche].peek();
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public T poll() {
        for (int tranche = this.highest; tranche >= 0; --tranche) {
            T value = this.queues[tranche].poll();
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

