/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import swim.concurrent.Stage;
import swim.io.Endpoint;
import swim.io.Modem;
import swim.io.Service;
import swim.io.ServiceRef;
import swim.io.Socket;
import swim.io.SocketModem;
import swim.io.SocketRef;
import swim.io.http.HttpClient;
import swim.io.http.HttpClientModem;
import swim.io.http.HttpService;
import swim.io.http.HttpSettings;
import swim.io.http.HttpSocketService;

public class HttpEndpoint {
    protected final Endpoint endpoint;
    protected HttpSettings httpSettings;

    public HttpEndpoint(Endpoint endpoint, HttpSettings httpSettings) {
        this.endpoint = endpoint;
        this.httpSettings = httpSettings;
    }

    public HttpEndpoint(Endpoint endpoint) {
        this(endpoint, HttpSettings.standard());
    }

    public HttpEndpoint(Stage stage, HttpSettings httpSettings) {
        this(new Endpoint(stage), httpSettings);
    }

    public HttpEndpoint(Stage stage) {
        this(new Endpoint(stage), HttpSettings.standard());
    }

    public final HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public final Stage stage() {
        return this.endpoint.stage();
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public void start() {
        this.endpoint.start();
    }

    public void stop() {
        this.endpoint.stop();
    }

    public ServiceRef bindHttp(InetSocketAddress localAddress, HttpService service, HttpSettings httpSettings) {
        HttpSocketService tcpService = new HttpSocketService(service, httpSettings);
        return this.endpoint.bindTcp(localAddress, (Service)tcpService, httpSettings.socketSettings());
    }

    public ServiceRef bindHttp(InetSocketAddress localAddress, HttpService service) {
        return this.bindHttp(localAddress, service, this.httpSettings);
    }

    public ServiceRef bindHttp(String address, int port, HttpService service, HttpSettings httpSettings) {
        return this.bindHttp(new InetSocketAddress(address, port), service, httpSettings);
    }

    public ServiceRef bindHttp(String address, int port, HttpService service) {
        return this.bindHttp(new InetSocketAddress(address, port), service, this.httpSettings);
    }

    public ServiceRef bindHttps(InetSocketAddress localAddress, HttpService service, HttpSettings httpSettings) {
        HttpSocketService tlsService = new HttpSocketService(service, httpSettings);
        return this.endpoint.bindTls(localAddress, (Service)tlsService, httpSettings.socketSettings());
    }

    public ServiceRef bindHttps(InetSocketAddress localAddress, HttpService service) {
        return this.bindHttps(localAddress, service, this.httpSettings);
    }

    public ServiceRef bindHttps(String address, int port, HttpService service, HttpSettings httpSettings) {
        return this.bindHttps(new InetSocketAddress(address, port), service, httpSettings);
    }

    public ServiceRef bindHttps(String address, int port, HttpService service) {
        return this.bindHttps(new InetSocketAddress(address, port), service, this.httpSettings);
    }

    public SocketRef connectHttp(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        SocketModem socket = new SocketModem((Modem)modem);
        return this.endpoint.connectTcp(remoteAddress, (Socket)socket, httpSettings.socketSettings());
    }

    public SocketRef connectHttp(InetSocketAddress remoteAddress, HttpClient client) {
        return this.connectHttp(remoteAddress, client, this.httpSettings);
    }

    public SocketRef connectHttp(String address, int port, HttpClient client, HttpSettings httpSettings) {
        return this.connectHttp(new InetSocketAddress(address, port), client, httpSettings);
    }

    public SocketRef connectHttp(String address, int port, HttpClient client) {
        return this.connectHttp(new InetSocketAddress(address, port), client, this.httpSettings);
    }

    public SocketRef connectHttps(InetSocketAddress remoteAddress, HttpClient client, HttpSettings httpSettings) {
        HttpClientModem modem = new HttpClientModem(client, httpSettings);
        SocketModem socket = new SocketModem((Modem)modem);
        return this.endpoint.connectTls(remoteAddress, (Socket)socket, httpSettings.socketSettings());
    }

    public SocketRef connectHttps(InetSocketAddress remoteAddress, HttpClient client) {
        return this.connectHttps(remoteAddress, client, this.httpSettings);
    }

    public SocketRef connectHttps(String address, int port, HttpClient client, HttpSettings httpSettings) {
        return this.connectHttps(new InetSocketAddress(address, port), client, httpSettings);
    }

    public SocketRef connectHttps(String address, int port, HttpClient client) {
        return this.connectHttps(new InetSocketAddress(address, port), client, this.httpSettings);
    }
}

