/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Decoder;
import swim.codec.InputBuffer;
import swim.deflate.Inflate;
import swim.ws.WsDecoder;
import swim.ws.WsFrame;
import swim.ws.WsFrameDecoder;
import swim.ws.WsFrameInflater;

public class WsDeflateDecoder
extends WsDecoder
implements Cloneable {
    protected final Inflate<?> inflate;
    protected boolean decompressing;

    public WsDeflateDecoder(Inflate<?> inflate, boolean decompressing) {
        this.inflate = inflate;
        this.decompressing = decompressing;
    }

    public WsDeflateDecoder(Inflate<?> inflate) {
        this(inflate, false);
    }

    public final Inflate<?> inflate() {
        return this.inflate;
    }

    public final boolean decompressing() {
        return this.decompressing;
    }

    @Override
    public <T> Decoder<WsFrame<T>> decodeContinuationFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        if (this.decompressing) {
            return WsFrameInflater.decode(input, this, content);
        }
        return WsFrameDecoder.decode(input, this, content);
    }

    @Override
    public <T> Decoder<WsFrame<T>> decodeTextFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        if ((finRsvOp & 0x40) != 0) {
            this.decompressing = (finRsvOp & 0x80) == 0;
            return WsFrameInflater.decode(input, this, content);
        }
        this.decompressing = false;
        return WsFrameDecoder.decode(input, this, content);
    }

    @Override
    public <T> Decoder<WsFrame<T>> decodeBinaryFrame(int finRsvOp, Decoder<T> content, InputBuffer input) {
        if ((finRsvOp & 0x40) != 0) {
            this.decompressing = (finRsvOp & 0x80) == 0;
            return WsFrameInflater.decode(input, this, content);
        }
        this.decompressing = false;
        return WsFrameDecoder.decode(input, this, content);
    }

    public WsDeflateDecoder clone() {
        return new WsDeflateDecoder(this.inflate.clone(), this.decompressing);
    }
}

