/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Output;
import swim.math.Precision;
import swim.math.Tensor;
import swim.math.TensorDims;

public class MutableTensor
extends Tensor {
    protected MutableTensor(TensorDims dims, Object array, int offset) {
        super(dims, array, offset);
    }

    public MutableTensor(TensorDims dims, double[] array, int offset) {
        super(dims, array, offset);
    }

    public MutableTensor(TensorDims dims, float[] array, int offset) {
        super(dims, array, offset);
    }

    public MutableTensor(TensorDims dims, double ... array) {
        super(dims, array);
    }

    public MutableTensor(TensorDims dims, float ... array) {
        super(dims, array);
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("MutableTensor").write(46).write("of").write(40).debug((Object)this.dims).write(", ").debug((Object)this.offset);
        Object us = this.array;
        if (us instanceof double[]) {
            Tensor.debug(output, (double[])us);
        } else if (us instanceof float[]) {
            Tensor.debug(output, (float[])us);
        } else {
            throw new AssertionError();
        }
        output = output.write(41);
    }

    public static MutableTensor zero(TensorDims dims, Precision prec) {
        if (prec.isDouble()) {
            return new MutableTensor(dims, new double[dims.size * dims.stride]);
        }
        if (prec.isSingle()) {
            return new MutableTensor(dims, new float[dims.size * dims.stride]);
        }
        throw new AssertionError();
    }

    public static MutableTensor zero(TensorDims dims) {
        return MutableTensor.zero(dims, Precision.f32());
    }

    public static MutableTensor of(TensorDims dims, int offset, double ... array) {
        return new MutableTensor(dims, array, offset);
    }

    public static MutableTensor of(TensorDims dims, int offset, float ... array) {
        return new MutableTensor(dims, array, offset);
    }
}

