/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import java.lang.reflect.Array;
import swim.math.Field;
import swim.math.TensorArrayForm;
import swim.math.TensorArraySpace;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.TensorSpace;

final class TensorArrayIdentitySpace<V, S>
extends TensorArraySpace<V[], V, S> {
    final Class<V> type;
    final TensorSpace<V, S> next;
    final TensorDims dims;

    TensorArrayIdentitySpace(Class<V> type, TensorSpace<V, S> next, TensorDims dims) {
        this.type = type;
        this.next = next;
        this.dims = dims;
    }

    @Override
    public Field<S> scalar() {
        return this.next.scalar();
    }

    @Override
    public TensorDims dimensions() {
        return this.dims;
    }

    @Override
    public TensorSpace<V, S> next() {
        return this.next;
    }

    @Override
    public V[] of(Object ... array) {
        return array;
    }

    @Override
    public Object[] toArray(V[] tensor) {
        return tensor;
    }

    @Override
    public TensorForm<V[]> form(TensorForm<V> next) {
        return TensorArrayForm.from(next);
    }

    @Override
    protected Object[] newArray(int length) {
        return (Object[])Array.newInstance(this.type, length);
    }
}

