/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.runtime.downlink.DownlinkModem;
import swim.runtime.downlink.DownlinkRelayDidClose;
import swim.runtime.downlink.DownlinkRelayDidConnect;
import swim.runtime.downlink.DownlinkRelayDidDisconnect;
import swim.runtime.downlink.DownlinkRelayDidFail;
import swim.runtime.downlink.DownlinkRelayDidLink;
import swim.runtime.downlink.DownlinkRelayDidSync;
import swim.runtime.downlink.DownlinkRelayDidUnlink;
import swim.runtime.downlink.DownlinkRelayOnEvent;
import swim.runtime.downlink.DownlinkRelayWillCommand;
import swim.runtime.downlink.DownlinkRelayWillLink;
import swim.runtime.downlink.DownlinkRelayWillSync;
import swim.runtime.downlink.DownlinkRelayWillUnlink;
import swim.runtime.downlink.DownlinkView;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class DownlinkModel<View extends DownlinkView>
extends DownlinkModem {
    protected volatile Object views;
    static final AtomicReferenceFieldUpdater<DownlinkModel<?>, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(DownlinkModel.class, Object.class, "views");

    public DownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    @Override
    public final boolean keepLinked() {
        Object views = this.views;
        if (views instanceof DownlinkView) {
            return ((DownlinkView)views).keepLinked();
        }
        if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                if (!viewArray[i].keepLinked()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean keepSynced() {
        Object views = this.views;
        if (views instanceof DownlinkView) {
            return ((DownlinkView)views).keepSynced();
        }
        if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                if (!viewArray[i].keepSynced()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void pushDownEvent(EventMessage message) {
        this.onEvent(message);
        new DownlinkRelayOnEvent(this, message).run();
    }

    @Override
    protected void pushDownLinked(LinkedResponse response) {
        this.didLink(response);
        new DownlinkRelayDidLink(this, response).run();
    }

    @Override
    protected void pushDownSynced(SyncedResponse response) {
        this.didSync(response);
        new DownlinkRelayDidSync(this, response).run();
    }

    @Override
    protected void pushDownUnlinked(UnlinkedResponse response) {
        this.didUnlink(response);
        new DownlinkRelayDidUnlink(this, response).run();
    }

    @Override
    protected void pullUpCommand(CommandMessage message) {
        this.onCommand(message);
        new DownlinkRelayWillCommand(this, message).run();
    }

    @Override
    protected void pullUpLink(LinkRequest request) {
        this.willLink(request);
        new DownlinkRelayWillLink(this, request).run();
    }

    @Override
    protected void pullUpSync(SyncRequest request) {
        this.willSync(request);
        new DownlinkRelayWillSync(this, request).run();
    }

    @Override
    protected void pullUpUnlink(UnlinkRequest request) {
        this.willUnlink(request);
        new DownlinkRelayWillUnlink(this, request).run();
    }

    public void addDownlink(View view) {
        Object newViews;
        Object oldViews;
        do {
            if ((oldViews = this.views) instanceof DownlinkView) {
                newViews = new DownlinkView[]{(DownlinkView)oldViews, view};
                continue;
            }
            if (oldViews instanceof DownlinkView[]) {
                DownlinkView[] oldViewArray = (DownlinkView[])oldViews;
                int n = oldViewArray.length;
                DownlinkView[] newViewArray = new DownlinkView[n + 1];
                System.arraycopy(oldViewArray, 0, newViewArray, 0, n);
                newViewArray[n] = view;
                newViews = newViewArray;
                continue;
            }
            newViews = view;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        this.didAddDownlink(view);
        if (oldViews == null) {
            this.openDown();
        }
    }

    public void removeDownlink(View view) {
        DownlinkView[] newViews;
        DownlinkView[] oldViews;
        do {
            if ((oldViews = this.views) instanceof DownlinkView) {
                if (oldViews == view) {
                    newViews = null;
                    continue;
                }
            } else if (oldViews instanceof DownlinkView[]) {
                DownlinkView[] oldViewArray = oldViews;
                int n = oldViewArray.length;
                if (n == 2) {
                    if (oldViewArray[0] == view) {
                        newViews = oldViewArray[1];
                        continue;
                    }
                    if (oldViewArray[1] == view) {
                        newViews = oldViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    DownlinkView[] newViewArray = new DownlinkView[n - 1];
                    for (i = 0; i < n && oldViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newViewArray[i] = oldViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldViewArray, i + 1, newViewArray, i, n - (i + 1));
                        newViews = newViewArray;
                        continue;
                    }
                }
            }
            newViews = oldViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldViews, newViews));
        if (oldViews != newViews) {
            this.didRemoveDownlink(view);
        }
        if (newViews == null) {
            this.closeDown();
        }
    }

    protected void didAddDownlink(View view) {
    }

    protected void didRemoveDownlink(View view) {
    }

    @Override
    public void reopen() {
        Object views = VIEWS.getAndSet(this, null);
        if (views instanceof DownlinkView) {
            DownlinkView view = views;
            view.close();
            this.didRemoveDownlink(view);
            this.closeDown();
            view.open();
        } else if (views instanceof DownlinkView[]) {
            DownlinkView view;
            int i;
            DownlinkView[] viewArray = views;
            int n = viewArray.length;
            for (i = 0; i < n; ++i) {
                view = viewArray[i];
                view.close();
                this.didRemoveDownlink(view);
            }
            this.closeDown();
            for (i = 0; i < n; ++i) {
                view = viewArray[i];
                view.open();
            }
        }
    }

    @Override
    public void didConnect() {
        super.didConnect();
        new DownlinkRelayDidConnect(this).run();
    }

    @Override
    public void didDisconnect() {
        super.didDisconnect();
        new DownlinkRelayDidDisconnect(this).run();
    }

    @Override
    public void didCloseUp() {
        super.didCloseUp();
        new DownlinkRelayDidClose(this).run();
    }

    @Override
    public void didFail(Throwable error) {
        super.didFail(error);
        new DownlinkRelayDidFail(this, error).run();
    }
}

