/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.uplink;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.api.auth.Identity;
import swim.api.http.HttpUplink;
import swim.codec.Decoder;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Stage;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.runtime.HttpBinding;
import swim.runtime.HttpContext;
import swim.uri.Uri;

public abstract class HttpUplinkModem
implements HttpContext,
HttpUplink {
    protected final HttpBinding httpBinding;

    public HttpUplinkModem(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public final Uri hostUri() {
        return this.httpBinding.hostUri();
    }

    public final Uri nodeUri() {
        return this.httpBinding.nodeUri();
    }

    public final Uri laneUri() {
        return this.httpBinding.laneUri();
    }

    public final Uri requestUri() {
        return this.httpBinding.requestUri();
    }

    public final HttpRequest<?> request() {
        return this.httpBinding.request();
    }

    @Override
    public boolean isConnectedUp() {
        return true;
    }

    @Override
    public boolean isRemoteUp() {
        return false;
    }

    @Override
    public boolean isSecureUp() {
        return true;
    }

    @Override
    public String securityProtocolUp() {
        return null;
    }

    @Override
    public String cipherSuiteUp() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressUp() {
        return null;
    }

    @Override
    public Identity localIdentityUp() {
        return null;
    }

    @Override
    public Principal localPrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressUp() {
        return null;
    }

    @Override
    public Identity remoteIdentityUp() {
        return null;
    }

    @Override
    public Principal remotePrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    public boolean isConnected() {
        return this.httpBinding.isConnectedDown();
    }

    public boolean isRemote() {
        return this.httpBinding.isRemoteDown();
    }

    public boolean isSecure() {
        return this.httpBinding.isSecureDown();
    }

    public String securityProtocol() {
        return this.httpBinding.securityProtocolDown();
    }

    public String cipherSuite() {
        return this.httpBinding.cipherSuiteDown();
    }

    public InetSocketAddress localAddress() {
        return this.httpBinding.localAddressDown();
    }

    public Identity localIdentity() {
        return this.httpBinding.localIdentityDown();
    }

    public Principal localPrincipal() {
        return this.httpBinding.localPrincipalDown();
    }

    public Collection<Certificate> localCertificates() {
        return this.httpBinding.localCertificatesDown();
    }

    public InetSocketAddress remoteAddress() {
        return this.httpBinding.remoteAddressDown();
    }

    public Identity remoteIdentity() {
        return this.httpBinding.remoteIdentityDown();
    }

    public Principal remotePrincipal() {
        return this.httpBinding.remotePrincipalDown();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.httpBinding.remoteCertificatesDown();
    }

    public abstract Stage stage();

    public HttpUplinkModem observe(Object observer) {
        return this;
    }

    public HttpUplinkModem unobserve(Object observer) {
        return this;
    }

    @Override
    public abstract Decoder<Object> decodeRequest(HttpRequest<?> var1);

    @Override
    public abstract void willRequest(HttpRequest<?> var1);

    @Override
    public abstract void didRequest(HttpRequest<Object> var1);

    @Override
    public abstract void willRespond(HttpResponse<?> var1);

    public void writeResponse(HttpResponse<?> response) {
        this.httpBinding.writeResponse(response);
    }

    @Override
    public abstract void didRespond(HttpResponse<?> var1);

    @Override
    public void closeUp() {
    }

    public void close() {
        this.httpBinding.closeDown();
    }

    @Override
    public void traceUp(Object message) {
    }

    @Override
    public void debugUp(Object message) {
    }

    @Override
    public void infoUp(Object message) {
    }

    @Override
    public void warnUp(Object message) {
    }

    @Override
    public void errorUp(Object message) {
    }

    public void trace(Object message) {
        this.httpBinding.traceDown(message);
    }

    public void debug(Object message) {
        this.httpBinding.debugDown(message);
    }

    public void info(Object message) {
        this.httpBinding.infoDown(message);
    }

    public void warn(Object message) {
        this.httpBinding.warnDown(message);
    }

    public void error(Object message) {
        this.httpBinding.errorDown(message);
    }
}

