/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriAuthorityPattern;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.uri.UriSchemePattern;

final class UriSchemeLiteral
extends UriSchemePattern {
    final UriScheme scheme;
    final UriAuthorityPattern rest;

    UriSchemeLiteral(UriScheme scheme, UriAuthorityPattern rest) {
        this.scheme = scheme;
        this.rest = rest;
    }

    @Override
    public Uri toUri() {
        return this.rest.toUri();
    }

    @Override
    Uri apply(String[] args, int index) {
        return this.rest.apply(this.scheme, args, index);
    }

    @Override
    HashTrieMap<String, String> unapply(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        if (this.scheme.equals(scheme)) {
            return this.rest.unapply(authority, path, query, fragment, args);
        }
        return args;
    }

    @Override
    boolean matches(UriScheme scheme, UriAuthority authority, UriPath path, UriQuery query, UriFragment fragment) {
        if (this.scheme.equals(scheme)) {
            return this.rest.matches(authority, path, query, fragment);
        }
        return false;
    }
}

