/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Decoder;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.Parser;
import swim.decipher.DecipherDecoder;
import swim.json.Json;
import swim.protobuf.Protobuf;
import swim.recon.Recon;
import swim.structure.Data;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.xml.Xml;

public class DecipherModelDecoder
extends DecipherDecoder<Item, Value> {
    @Override
    public Parser<Value> xmlParser() {
        return Xml.modelParser().documentParser();
    }

    @Override
    public Parser<Value> parseXml(Input input) {
        return Xml.modelParser().parseDocument(input);
    }

    @Override
    public Parser<Value> jsonParser() {
        return Json.modelParser().objectParser();
    }

    @Override
    public Parser<Value> parseJson(Input input) {
        return Json.modelParser().parseObject(input);
    }

    @Override
    public Parser<Value> reconParser() {
        return Recon.modelParser().blockParser();
    }

    @Override
    public Parser<Value> parseRecon(Input input) {
        return Recon.modelParser().parseBlock(input);
    }

    @Override
    public Decoder<Value> protobufDecoder() {
        return Protobuf.modelDecoder().payloadDecoder();
    }

    @Override
    public Decoder<Value> decodeProtobuf(InputBuffer input) {
        return Protobuf.modelDecoder().decodePayload(input);
    }

    @Override
    public Output<Value> textOutput() {
        return Text.output();
    }

    @Override
    public Output<Value> dataOutput() {
        return Data.output();
    }
}

