/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.StringWriter;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base16IntegerWriter
extends Writer<Object, Object> {
    final Object value;
    final long input;
    final int width;
    final Base16 base16;
    final int index;
    final int step;

    Base16IntegerWriter(Object value, long input, int width, Base16 base16, int index, int step) {
        this.value = value;
        this.input = input;
        this.width = width;
        this.base16 = base16;
        this.index = index;
        this.step = step;
    }

    Base16IntegerWriter(Object value, int input, int width, Base16 base16, boolean literal) {
        this(value, (long)input & 0xFFFFFFFFL, width, base16, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Object value, long input, int width, Base16 base16, boolean literal) {
        this(value, input, width, base16, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Object value, float input, int width, Base16 base16, boolean literal) {
        this(value, (long)Float.floatToIntBits(input) & 0xFFFFFFFFL, width, base16, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Object value, double input, int width, Base16 base16, boolean literal) {
        this(value, Double.doubleToLongBits(input), width, base16, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(int width, Base16 base16, boolean literal) {
        this(null, 0L, width, base16, 0, literal ? -1 : -3);
    }

    @Override
    public Writer<Object, Object> feed(Object input) {
        if (input instanceof Integer) {
            return new Base16IntegerWriter(input, (Integer)input, this.width, this.base16, this.step == -1);
        }
        if (input instanceof Long) {
            return new Base16IntegerWriter(input, (Long)input, this.width, this.base16, this.step == -1);
        }
        if (input instanceof Float) {
            return new Base16IntegerWriter(input, ((Float)input).floatValue(), this.width, this.base16, this.step == -1);
        }
        if (input instanceof Double) {
            return new Base16IntegerWriter(input, (Double)input, this.width, this.base16, this.step == -1);
        }
        return new StringWriter(input, input);
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base16IntegerWriter.write(output, this.value, this.input, this.width, this.base16, this.index, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, long input, int width, Base16 base16, int index, int step) {
        if (step <= 0) {
            return Base16IntegerWriter.done();
        }
        if (step == 1 && output.isCont()) {
            output = output.write(48);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(120);
            step = 3;
        }
        if (step == 3) {
            if (input >= 0L && input < 16L && width <= 1) {
                if (output.isCont()) {
                    output = output.write(base16.encodeDigit((int)input));
                    return Base16IntegerWriter.done(value);
                }
            } else {
                int i = 15;
                int[] digits = new int[16];
                for (long x = input; x != 0L || i >= 16 - width; x >>>= 4, --i) {
                    digits[i] = (int)x & 0xF;
                }
                i += 1 + index;
                while (i < 16 && output.isCont()) {
                    output = output.write(base16.encodeDigit(digits[i]));
                    ++index;
                    ++i;
                }
                if (i == 16) {
                    return Base16IntegerWriter.done(value);
                }
            }
        }
        if (output.isDone()) {
            return Base16IntegerWriter.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Base16IntegerWriter.error(output.trap());
        }
        return new Base16IntegerWriter(value, input, width, base16, index, step);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, int input, int width, Base16 base16, boolean literal) {
        return Base16IntegerWriter.write(output, null, (long)input & 0xFFFFFFFFL, width, base16, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, long input, int width, Base16 base16, boolean literal) {
        return Base16IntegerWriter.write(output, null, input, width, base16, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, float input, int width, Base16 base16, boolean literal) {
        return Base16IntegerWriter.write(output, null, (long)Float.floatToIntBits(input) & 0xFFFFFFFFL, width, base16, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, double input, int width, Base16 base16, boolean literal) {
        return Base16IntegerWriter.write(output, null, Double.doubleToLongBits(input), width, base16, 0, literal ? 1 : 3);
    }
}

