/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.DecoderDone;
import swim.codec.DecoderError;
import swim.codec.InputBuffer;

public abstract class Decoder<O> {
    private static Decoder<Object> done;

    public boolean isCont() {
        return true;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public abstract Decoder<O> feed(InputBuffer var1);

    public Decoder<O> fork(Object condition) {
        return this;
    }

    public O bind() {
        throw new IllegalStateException();
    }

    public Throwable trap() {
        throw new IllegalStateException();
    }

    public <O> Decoder<O> asError() {
        throw new IllegalStateException();
    }

    public static <O> Decoder<O> done() {
        if (done == null) {
            done = new DecoderDone<Object>(null);
        }
        return done;
    }

    public static <O> Decoder<O> done(O output) {
        if (output == null) {
            return Decoder.done();
        }
        return new DecoderDone<O>(output);
    }

    public static <O> Decoder<O> error(Throwable error) {
        return new DecoderError(error);
    }
}

