/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.BTree;
import swim.collections.BTreeContext;
import swim.collections.BTreePage;
import swim.util.CombinerFunction;
import swim.util.Cursor;
import swim.util.OrderedMapCursor;
import swim.util.ReducedMap;

public class BTreeMap<K, V, U>
extends BTreeContext<K, V>
implements ReducedMap<K, V, U>,
Cloneable,
Debug {
    volatile BTreePage<K, V, U> root;
    static final AtomicReferenceFieldUpdater<BTreeMap, BTreePage> ROOT = AtomicReferenceFieldUpdater.newUpdater(BTreeMap.class, BTreePage.class, "root");

    protected BTreeMap(BTreePage<K, V, U> root) {
        this.root = root;
    }

    public BTreeMap() {
        this(BTreePage.empty());
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public int size() {
        return this.root.size();
    }

    public boolean containsKey(Object key) {
        return this.root.containsKey(key, this);
    }

    public boolean containsValue(Object value) {
        return this.root.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.root.indexOf(key, this);
    }

    public V get(Object key) {
        return this.root.get(key, this);
    }

    public Map.Entry<K, V> getEntry(Object key) {
        return this.root.getEntry(key, this);
    }

    public Map.Entry<K, V> getIndex(int index) {
        return this.root.getIndex(index);
    }

    public Map.Entry<K, V> firstEntry() {
        return this.root.firstEntry();
    }

    public K firstKey() {
        Map.Entry<K, V> entry = this.root.firstEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V firstValue() {
        Map.Entry<K, V> entry = this.root.firstEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> lastEntry() {
        return this.root.lastEntry();
    }

    public K lastKey() {
        Map.Entry<K, V> entry = this.root.lastEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V lastValue() {
        Map.Entry<K, V> entry = this.root.lastEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> nextEntry(K key) {
        return this.root.nextEntry(key, this);
    }

    public K nextKey(K key) {
        Map.Entry<K, V> entry = this.root.nextEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V nextValue(K key) {
        Map.Entry<K, V> entry = this.root.nextEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> previousEntry(K key) {
        return this.root.previousEntry(key, this);
    }

    public K previousKey(K key) {
        Map.Entry<K, V> entry = this.root.previousEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V previousValue(K key) {
        Map.Entry<K, V> entry = this.root.previousEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public V put(K key, V newValue) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root) != (newRoot = oldRoot.updated(key, newValue, this))) {
            if (newRoot.size() > oldRoot.size()) {
                newRoot = newRoot.balanced(this);
            }
            if (!ROOT.compareAndSet(this, oldRoot, newRoot)) continue;
            break;
        }
        return oldRoot.get(key, this);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root) != (newRoot = oldRoot.removed(key, this).balanced(this))) {
            if (!ROOT.compareAndSet(this, oldRoot, newRoot)) continue;
            return oldRoot.get(key, this);
        }
        return null;
    }

    public BTreeMap<K, V, U> drop(int lower) {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        do {
            oldRoot = this.root;
        } while (lower > 0 && oldRoot.size() > 0 && !ROOT.compareAndSet(this, oldRoot, newRoot = lower < oldRoot.size() ? oldRoot.drop(lower, this).balanced(this) : BTreePage.empty()));
        return this;
    }

    public BTreeMap<K, V, U> take(int upper) {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        while (upper < (oldRoot = this.root).size() && oldRoot.size() > 0 && !ROOT.compareAndSet(this, oldRoot, newRoot = upper > 0 ? oldRoot.take(upper, this).balanced(this) : BTreePage.empty())) {
        }
        return this;
    }

    public void clear() {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root) != (newRoot = BTreePage.empty()) && !ROOT.compareAndSet(this, oldRoot, newRoot)) {
        }
    }

    public BTreeMap<K, V, U> updated(K key, V newValue) {
        BTreePage<K, V, U> oldRoot = this.root;
        BTreePage<K, V, U> newRoot = oldRoot.updated(key, newValue, this);
        if (newRoot.size() > oldRoot.size()) {
            newRoot = newRoot.balanced(this);
        }
        return this.copy(newRoot);
    }

    public BTreeMap<K, V, U> removed(K key) {
        return this.copy(this.root.removed(key, this).balanced(this));
    }

    public BTreeMap<K, V, U> cleared() {
        return this.copy(BTreePage.empty());
    }

    public U reduced(U identity, CombinerFunction<? super V, U> accumulator, CombinerFunction<U, U> combiner) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, ? super V, U> oldRoot;
        while ((oldRoot = this.root) != (newRoot = oldRoot.reduced(identity, accumulator, combiner)) && !ROOT.compareAndSet(this, oldRoot, newRoot)) {
        }
        return newRoot.fold();
    }

    public BTree<K, V> snapshot() {
        return new BTree<K, V>(this.root);
    }

    public OrderedMapCursor<K, V> iterator() {
        return this.root.iterator();
    }

    public Cursor<K> keyIterator() {
        return this.root.keyIterator();
    }

    public Cursor<V> valueIterator() {
        return this.root.valueIterator();
    }

    public OrderedMapCursor<K, V> lastIterator() {
        return this.root.lastIterator();
    }

    public Cursor<K> lastKeyIterator() {
        return this.root.lastKeyIterator();
    }

    public Cursor<V> lastValueIterator() {
        return this.root.lastValueIterator();
    }

    public BTreeMap<K, V, U> clone() {
        return this.copy(this.root);
    }

    protected BTreeMap<K, V, U> copy(BTreePage<K, V, U> root) {
        return new BTreeMap<K, V, U>(root);
    }

    public Comparator<? super K> comparator() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (this.size() == that.size()) {
                for (Map.Entry entry : that.entrySet()) {
                    V value = this.get(entry.getKey());
                    Object v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        OrderedMapCursor<K, V> these = this.iterator();
        while (these.hasNext()) {
            code += ((Map.Entry)these.next()).hashCode();
        }
        return code;
    }

    public void debug(Output<?> output) {
        output = output.write("BTreeMap").write(46);
        OrderedMapCursor<K, V> these = this.iterator();
        if (these.hasNext()) {
            Map.Entry entry = (Map.Entry)these.next();
            output = output.write("of").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            while (these.hasNext()) {
                entry = (Map.Entry)these.next();
                output = output.write(41).write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <K, V, U> BTreeMap<K, V, U> empty() {
        return new BTreeMap<K, V, U>();
    }

    public static <K, V, U> BTreeMap<K, V, U> of(K key, V value) {
        BTreeMap<K, V, U> tree = new BTreeMap<K, V, U>();
        tree.put(key, value);
        return tree;
    }

    public static <K, V, U> BTreeMap<K, V, U> from(Map<? extends K, ? extends V> map) {
        BTreeMap<K, V, U> tree = new BTreeMap<K, V, U>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tree.put(entry.getKey(), entry.getValue());
        }
        return tree;
    }
}

