/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.collections.STreePage;
import swim.util.Cursor;

final class STreeNodeCursor<T>
implements Cursor<Map.Entry<Object, T>> {
    final STreePage<T>[] pages;
    long index;
    int pageIndex;
    Cursor<Map.Entry<Object, T>> pageCursor;

    STreeNodeCursor(STreePage<T>[] pages, long index, int pageIndex, Cursor<Map.Entry<Object, T>> pageCursor) {
        this.pages = pages;
        this.index = index;
        this.pageIndex = pageIndex;
        this.pageCursor = pageCursor;
    }

    STreeNodeCursor(STreePage<T>[] pages, long index, int pageIndex) {
        this(pages, index, pageIndex, null);
    }

    STreeNodeCursor(STreePage<T>[] pages) {
        this(pages, 0L, 0, null);
    }

    long pageSize(STreePage<T> page) {
        return page.size();
    }

    Cursor<Map.Entry<Object, T>> pageCursor(STreePage<T> page) {
        return page.entryIterator();
    }

    Cursor<Map.Entry<Object, T>> reversePageCursor(STreePage<T> page) {
        return page.reverseEntryIterator();
    }

    public boolean isEmpty() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    return false;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        return true;
    }

    public Map.Entry<Object, T> head() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    return (Map.Entry)this.pageCursor.head();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new NoSuchElementException();
    }

    public void step() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    ++this.index;
                    return;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        while (count > 0L) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    ++this.index;
                    --count;
                    this.pageCursor.next();
                    continue;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            STreePage<T> page = this.pages[this.pageIndex];
            long pageSize = this.pageSize(page);
            ++this.pageIndex;
            if (pageSize < count) {
                this.pageCursor = this.pageCursor(page);
                if (count <= 0L) break;
                this.index += count;
                this.pageCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += pageSize;
            count -= pageSize;
        }
    }

    public boolean hasNext() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        return false;
    }

    public long nextIndexLong() {
        return this.index;
    }

    public Map.Entry<Object, T> next() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    ++this.index;
                    return (Map.Entry)this.pageCursor.next();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasPrevious()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex <= 0) break;
            this.pageCursor = this.reversePageCursor(this.pages[this.pageIndex - 1]);
            --this.pageIndex;
        }
        this.pageIndex = 0;
        return false;
    }

    public long previousIndexLong() {
        return this.index - 1L;
    }

    public Map.Entry<Object, T> previous() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasPrevious()) {
                    --this.index;
                    return (Map.Entry)this.pageCursor.previous();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex <= 0) break;
            this.pageCursor = this.reversePageCursor(this.pages[this.pageIndex - 1]);
            --this.pageIndex;
        }
        this.pageIndex = 0;
        throw new NoSuchElementException();
    }

    public void set(Map.Entry<Object, T> newValue) {
        this.pageCursor.set(newValue);
    }

    public void remove() {
        this.pageCursor.remove();
    }
}

