/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base16Writer
extends Writer<Object, Object> {
    final Object value;
    final ByteBuffer input;
    final Base16 base16;
    final int index;
    final int limit;
    final int step;

    Base16Writer(Object value, ByteBuffer input, Base16 base16, int index, int limit, int step) {
        this.value = value;
        this.input = input;
        this.base16 = base16;
        this.index = index;
        this.limit = limit;
        this.step = step;
    }

    Base16Writer(Object value, ByteBuffer input, Base16 base16) {
        this(value, input, base16, input.position(), input.limit(), 1);
    }

    Base16Writer(ByteBuffer input, Base16 base16) {
        this(null, input, base16);
    }

    Base16Writer(Object value, byte[] input, Base16 base16) {
        this(value, ByteBuffer.wrap(input), base16);
    }

    Base16Writer(byte[] input, Base16 base16) {
        this(null, ByteBuffer.wrap(input), base16);
    }

    Base16Writer(Base16 base16) {
        this(null, null, base16, 0, 0, 1);
    }

    @Override
    public Writer<Object, Object> feed(Object value) {
        if (value instanceof ByteBuffer) {
            return new Base16Writer((ByteBuffer)value, this.base16);
        }
        if (value instanceof byte[]) {
            return new Base16Writer((byte[])value, this.base16);
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base16Writer.write(output, this.value, this.input, this.base16, this.index, this.limit, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, ByteBuffer input, Base16 base16, int index, int limit, int step) {
        while (index < limit) {
            int x = input.get(index) & 0xFF;
            if (step == 1 && output.isCont()) {
                output = output.write(base16.encodeDigit(x >>> 4));
                step = 2;
            }
            if (step != 2 || !output.isCont()) continue;
            output = output.write(base16.encodeDigit(x & 0xF));
            ++index;
            step = 1;
        }
        if (index == limit) {
            return Base16Writer.done(value);
        }
        if (output.isDone()) {
            return Base16Writer.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Base16Writer.error(output.trap());
        }
        return new Base16Writer(value, input, base16, index, limit, step);
    }

    static Writer<?, ?> write(Output<?> output, Object value, ByteBuffer input, Base16 base16) {
        return Base16Writer.write(output, value, input, base16, input.position(), input.limit(), 1);
    }

    static Writer<?, ?> write(Output<?> output, ByteBuffer input, Base16 base16) {
        return Base16Writer.write(output, null, input, base16);
    }

    static Writer<?, ?> write(Output<?> output, Object value, byte[] input, Base16 base16) {
        return Base16Writer.write(output, value, ByteBuffer.wrap(input), base16);
    }

    static Writer<?, ?> write(Output<?> output, byte[] input, Base16 base16) {
        return Base16Writer.write(output, null, ByteBuffer.wrap(input), base16);
    }
}

