/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.ContentCoding;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.header.AcceptEncoding;
import swim.util.Builder;

final class AcceptEncodingParser
extends Parser<AcceptEncoding> {
    final HttpParser http;
    final Parser<ContentCoding> coding;
    final Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings;
    final int step;

    AcceptEncodingParser(HttpParser http, Parser<ContentCoding> coding, Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings, int step) {
        this.http = http;
        this.coding = coding;
        this.codings = codings;
        this.step = step;
    }

    AcceptEncodingParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptEncoding> feed(Input input) {
        return AcceptEncodingParser.parse(input, this.http, this.coding, this.codings, this.step);
    }

    static Parser<AcceptEncoding> parse(Input input, HttpParser http, Parser<ContentCoding> coding, Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((coding = coding == null ? http.parseContentCoding(input) : coding.feed(input)).isDone()) {
                    if (codings == null) {
                        codings = FingerTrieSeq.builder();
                    }
                    codings.add((Object)((ContentCoding)coding.bind()));
                    coding = null;
                    step = 2;
                } else if (coding.isError()) {
                    return coding.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return AcceptEncodingParser.done((Object)AcceptEncoding.from((FingerTrieSeq<ContentCoding>)((FingerTrieSeq)codings.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return AcceptEncodingParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(coding = coding == null ? http.parseContentCoding(input) : coding.feed(input)).isDone()) break;
                codings.add((Object)((ContentCoding)coding.bind()));
                coding = null;
                step = 2;
            }
            if (coding.isError()) {
                return coding.asError();
            }
        }
        if (input.isError()) {
            return AcceptEncodingParser.error((Throwable)input.trap());
        }
        return new AcceptEncodingParser(http, (Parser<ContentCoding>)coding, (Builder<ContentCoding, FingerTrieSeq<ContentCoding>>)codings, step);
    }

    static Parser<AcceptEncoding> parse(Input input, HttpParser http) {
        return AcceptEncodingParser.parse(input, http, null, null, 1);
    }
}

