/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaRange;
import swim.http.header.Accept;
import swim.util.Builder;

final class AcceptParser
extends Parser<Accept> {
    final HttpParser http;
    final Parser<MediaRange> mediaRange;
    final Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges;
    final int step;

    AcceptParser(HttpParser http, Parser<MediaRange> mediaRange, Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges, int step) {
        this.http = http;
        this.mediaRange = mediaRange;
        this.mediaRanges = mediaRanges;
        this.step = step;
    }

    AcceptParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<Accept> feed(Input input) {
        return AcceptParser.parse(input, this.http, this.mediaRange, this.mediaRanges, this.step);
    }

    static Parser<Accept> parse(Input input, HttpParser http, Parser<MediaRange> mediaRange, Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((mediaRange = mediaRange == null ? http.parseMediaRange(input) : mediaRange.feed(input)).isDone()) {
                    if (mediaRanges == null) {
                        mediaRanges = FingerTrieSeq.builder();
                    }
                    mediaRanges.add((Object)((MediaRange)mediaRange.bind()));
                    mediaRange = null;
                    step = 2;
                } else if (mediaRange.isError()) {
                    return mediaRange.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return AcceptParser.done((Object)Accept.from((FingerTrieSeq<MediaRange>)((FingerTrieSeq)mediaRanges.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return AcceptParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(mediaRange = mediaRange == null ? http.parseMediaRange(input) : mediaRange.feed(input)).isDone()) break;
                mediaRanges.add((Object)((MediaRange)mediaRange.bind()));
                mediaRange = null;
                step = 2;
            }
            if (mediaRange.isError()) {
                return mediaRange.asError();
            }
        }
        if (input.isError()) {
            return AcceptParser.error((Throwable)input.trap());
        }
        return new AcceptParser(http, (Parser<MediaRange>)mediaRange, (Builder<MediaRange, FingerTrieSeq<MediaRange>>)mediaRanges, step);
    }

    static Parser<Accept> parse(Input input, HttpParser http) {
        return AcceptParser.parse(input, http, null, null, 1);
    }
}

