/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.DimensionException;
import swim.math.FN;
import swim.math.R;
import swim.math.TensorDims;
import swim.math.VectorRN;
import swim.math.VectorSpace;

public class RN
implements VectorSpace<VectorRN, Double>,
FN<VectorRN, Double>,
Debug {
    protected final TensorDims dims;

    protected RN(TensorDims dims) {
        this.dims = dims;
    }

    @Override
    public final R scalar() {
        return R.field();
    }

    @Override
    public final TensorDims dimensions() {
        return this.dims;
    }

    @Override
    public final int size() {
        return this.dims.size;
    }

    @Override
    public VectorRN zero() {
        return new VectorRN(new double[this.dims.size]);
    }

    @Override
    public VectorRN of(Object ... array) {
        int n = array.length;
        if (n != this.dims.size) {
            throw new DimensionException();
        }
        double[] us = new double[n];
        for (int i = 0; i < n; ++i) {
            us[i] = (Double)array[i];
        }
        return new VectorRN(us);
    }

    public VectorRN of(double ... array) {
        return VectorRN.of(array);
    }

    @Override
    public final Double get(VectorRN v, int i) {
        return v.get(i);
    }

    @Override
    public final VectorRN add(VectorRN u, VectorRN v) {
        return u.plus(v);
    }

    @Override
    public final VectorRN opposite(VectorRN v) {
        return v.opposite();
    }

    @Override
    public final VectorRN subtract(VectorRN u, VectorRN v) {
        return u.minus(v);
    }

    @Override
    public final VectorRN multiply(VectorRN u, Double a) {
        return u.times(a);
    }

    @Override
    public final VectorRN combine(Double a, VectorRN u, Double b, VectorRN v) {
        double[] us = u.array;
        double[] vs = v.array;
        int n = this.dims.size;
        if (us.length != n || vs.length != n) {
            throw new DimensionException();
        }
        double[] ws = new double[n];
        for (int i = 0; i < n; ++i) {
            ws[i] = a * us[i] + b * vs[i];
        }
        return new VectorRN(ws);
    }

    public void debug(Output<?> output) {
        output.write("RN").write(46).write("space").write(40).debug((Object)this.dims).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static RN space(TensorDims dims) {
        return new RN(dims);
    }

    public static RN space(int n) {
        return new RN(TensorDims.of(n));
    }
}

