/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.VectorZ3;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class VectorZ3Form
extends TensorForm<VectorZ3> {
    VectorZ3Form() {
    }

    public String tag() {
        return "vector";
    }

    public VectorZ3 unit() {
        return VectorZ3.zero();
    }

    public Class<?> type() {
        return VectorZ3.class;
    }

    public Item mold(VectorZ3 vector) {
        if (vector != null) {
            return Record.create((int)1).attr(this.tag(), (Value)Record.create((int)3).item(vector.x).item(vector.y).item(vector.z));
        }
        return Item.extant();
    }

    public VectorZ3 cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            long x = header.getItem(0).longValue(0L);
            long y = header.getItem(1).longValue(0L);
            long z = header.getItem(2).longValue(0L);
            return new VectorZ3(x, y, z);
        }
        return null;
    }

    @Override
    public VectorZ3 fromTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        long x = Math.round(tensor[offset]);
        long y = Math.round(tensor[offset += dim.stride]);
        long z = Math.round(tensor[offset += dim.stride]);
        return new VectorZ3(x, y, z);
    }

    @Override
    public VectorZ3 fromTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        long x = Math.round(tensor[offset]);
        long y = Math.round(tensor[offset += dim.stride]);
        long z = Math.round(tensor[offset += dim.stride]);
        return new VectorZ3(x, y, z);
    }

    @Override
    public void toTensor(VectorZ3 vector, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
        tensor[offset += dim.stride] = vector.z;
    }

    @Override
    public void toTensor(VectorZ3 vector, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        tensor[offset] = vector.x;
        tensor[offset += dim.stride] = vector.y;
        tensor[offset += dim.stride] = vector.z;
    }

    @Override
    public Item moldTensor(TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)3);
        header.item(Math.round(tensor[offset]));
        header.item(Math.round(tensor[offset += dim.stride]));
        header.item(Math.round(tensor[offset += dim.stride]));
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public Item moldTensor(TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Record header = Record.create((int)3);
        header.item(Math.round(tensor[offset]));
        header.item(Math.round(tensor[offset += dim.stride]));
        header.item(Math.round(tensor[offset += dim.stride]));
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims dim, float[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(1).floatValue(0.0f);
            tensor[offset += dim.stride] = header.getItem(2).floatValue(0.0f);
        }
    }

    @Override
    public void castTensor(Item item, TensorDims dim, double[] tensor, int offset) {
        if (dim.size != 3 || dim.next != null) {
            throw new DimensionException();
        }
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            tensor[offset] = header.getItem(0).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(1).doubleValue(0.0);
            tensor[offset += dim.stride] = header.getItem(2).doubleValue(0.0);
        }
    }
}

