/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LinkAddressed;
import swim.warp.SyncRequestForm;

public final class SyncRequest
extends LinkAddressed {
    @Kind
    public static final Form<SyncRequest> FORM = new SyncRequestForm();

    public SyncRequest(Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(nodeUri, laneUri, prio, rate, body);
    }

    public SyncRequest(Uri nodeUri, Uri laneUri, float prio, float rate) {
        this(nodeUri, laneUri, prio, rate, Value.absent());
    }

    public SyncRequest(Uri nodeUri, Uri laneUri, Value body) {
        this(nodeUri, laneUri, 0.0f, 0.0f, body);
    }

    public SyncRequest(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, 0.0f, 0.0f, Value.absent());
    }

    public SyncRequest(String nodeUri, String laneUri, float prio, float rate, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, body);
    }

    public SyncRequest(String nodeUri, String laneUri, float prio, float rate) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, Value.absent());
    }

    public SyncRequest(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, body);
    }

    public SyncRequest(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, Value.absent());
    }

    @Override
    public String tag() {
        return "sync";
    }

    public Form<SyncRequest> form() {
        return FORM;
    }

    @Override
    public SyncRequest nodeUri(Uri nodeUri) {
        return new SyncRequest(nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public SyncRequest laneUri(Uri laneUri) {
        return new SyncRequest(this.nodeUri, laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public SyncRequest body(Value body) {
        return new SyncRequest(this.nodeUri, this.laneUri, this.prio, this.rate, body);
    }
}

