/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import swim.structure.Item;
import swim.structure.Record;

final class RecordIterator
implements ListIterator<Item> {
    final Record record;
    int index;
    final int fromIndex;
    final int toIndex;
    int direction;

    RecordIterator(Record record, int index, int fromIndex, int toIndex) {
        this.record = record;
        this.index = index;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.direction = 0;
    }

    RecordIterator(Record record, int index) {
        this.record = record;
        this.index = index;
        this.fromIndex = 0;
        this.toIndex = record.size();
        this.direction = 0;
    }

    RecordIterator(Record record) {
        this.record = record;
        this.index = 0;
        this.fromIndex = 0;
        this.toIndex = record.size();
        this.direction = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.toIndex;
    }

    @Override
    public int nextIndex() {
        return this.index - this.fromIndex;
    }

    @Override
    public Item next() {
        int i = this.index;
        if (i < this.fromIndex || i >= this.toIndex) {
            throw new NoSuchElementException();
        }
        Item item = this.record.get(i);
        this.index = i + 1;
        this.direction = 1;
        return item;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > this.fromIndex;
    }

    @Override
    public int previousIndex() {
        return this.index - this.fromIndex - 1;
    }

    @Override
    public Item previous() {
        int i = this.index - 1;
        if (i < this.fromIndex || i >= this.toIndex) {
            throw new NoSuchElementException();
        }
        this.index = i;
        this.direction = -1;
        return this.record.get(i);
    }

    @Override
    public void add(Item newItem) {
        int i = this.index;
        this.record.add(i, newItem);
        this.index = i + 1;
        this.direction = 0;
    }

    @Override
    public void set(Item newItem) {
        if (this.direction == 0) {
            throw new IllegalStateException();
        }
        if (this.direction > 0) {
            this.record.set(this.index - 1, newItem);
        } else {
            this.record.set(this.index, newItem);
        }
    }

    @Override
    public void remove() {
        if (this.direction == 0) {
            throw new IllegalStateException();
        }
        if (this.direction > 0) {
            --this.index;
        }
        this.record.remove(this.index);
        this.direction = 0;
    }
}

