/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Comparator;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.math.Z2Form;
import swim.spatial.BitInterval;
import swim.spatial.QTreeContext;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreePage;
import swim.spatial.QTreeShapeCursor;
import swim.spatial.SpatialMap;
import swim.util.Cursor;
import swim.util.Murmur3;

public class QTree<K, S, V>
extends QTreeContext<K, S, V>
implements SpatialMap<K, S, V>,
Comparator<QTreeEntry<K, S, V>>,
Cloneable,
Debug {
    final Z2Form<S> shapeForm;
    QTreePage<K, S, V> root;
    private static int hashSeed;

    protected QTree(Z2Form<S> shapeForm, QTreePage<K, S, V> root) {
        this.shapeForm = shapeForm;
        this.root = root;
    }

    public QTree(Z2Form<S> shapeForm) {
        this(shapeForm, QTreePage.empty());
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public int size() {
        return (int)this.root.span();
    }

    @Override
    public boolean containsKey(K key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        long y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape));
        return this.root.containsKey(key, x, y, this);
    }

    @Override
    public boolean containsKey(Object key) {
        Cursor<QTreeEntry<K, S, V>> cursor = this.root.cursor();
        while (cursor.hasNext()) {
            if (!key.equals(((QTreeEntry)cursor.next()).key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Cursor<QTreeEntry<K, S, V>> cursor = this.root.cursor();
        while (cursor.hasNext()) {
            if (!value.equals(((QTreeEntry)cursor.next()).value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(K key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        long y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape));
        return this.root.get(key, x, y, this);
    }

    @Override
    public V get(Object key) {
        Cursor<QTreeEntry<K, S, V>> cursor = this.root.cursor();
        while (cursor.hasNext()) {
            QTreeEntry slot = (QTreeEntry)cursor.next();
            if (!key.equals(slot.key)) continue;
            return slot.value;
        }
        return null;
    }

    @Override
    public V put(K key, S shape, V newValue) {
        long y;
        QTreePage<K, S, V> oldRoot = this.root;
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        QTreePage<K, S, V> newRoot = oldRoot.updated(key, shape, x, y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape)), newValue, this).balanced(this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return oldRoot.get(key, x, y, this);
        }
        return null;
    }

    @Override
    public V move(K key, S oldShape, S newShape, V newValue) {
        Z2Form<S> shapeForm = this.shapeForm;
        long oldX = BitInterval.span(shapeForm.getXMin(oldShape), shapeForm.getXMax(oldShape));
        long oldY = BitInterval.span(shapeForm.getYMin(oldShape), shapeForm.getYMax(oldShape));
        long newX = BitInterval.span(shapeForm.getXMin(newShape), shapeForm.getXMax(newShape));
        long newY = BitInterval.span(shapeForm.getYMin(newShape), shapeForm.getYMax(newShape));
        QTreePage<K, S, V> oldRoot = this.root;
        QTreePage<K, S, V> newRoot = oldRoot.removed(key, oldX, oldY, this).balanced(this).updated(key, newShape, newX, newY, newValue, this).balanced(this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return oldRoot.get(key, oldX, oldY, this);
        }
        return null;
    }

    @Override
    public V remove(K key, S shape) {
        long y;
        QTreePage<K, S, V> oldRoot = this.root;
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        QTreePage<K, S, V> newRoot = oldRoot.removed(key, x, y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape)), this).balanced(this);
        if (oldRoot != newRoot) {
            this.root = newRoot;
            return oldRoot.get(key, x, y, this);
        }
        return null;
    }

    @Override
    public void clear() {
        this.root = QTreePage.empty();
    }

    public QTree<K, S, V> updated(K key, S shape, V newValue) {
        long y;
        QTreePage<K, S, V> oldRoot = this.root;
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        QTreePage<K, S, V> newRoot = oldRoot.updated(key, shape, x, y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape)), newValue, this);
        if (oldRoot != newRoot) {
            if (newRoot.span() > oldRoot.span()) {
                newRoot = newRoot.balanced(this);
            }
            return this.copy(newRoot);
        }
        return this;
    }

    public QTree<K, S, V> removed(K key, S shape) {
        long y;
        QTreePage<K, S, V> oldRoot = this.root;
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        QTreePage<K, S, V> newRoot = oldRoot.removed(key, x, y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape)), this);
        if (oldRoot != newRoot) {
            newRoot = newRoot.balanced(this);
            return this.copy(newRoot);
        }
        return this;
    }

    @Override
    public Cursor<SpatialMap.Entry<K, S, V>> iterator(S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span(shapeForm.getXMin(shape), shapeForm.getXMax(shape));
        long y = BitInterval.span(shapeForm.getYMin(shape), shapeForm.getYMax(shape));
        return new QTreeShapeCursor<K, S, V>(this.root.cursor(x, y), shapeForm, shape);
    }

    @Override
    public Cursor<SpatialMap.Entry<K, S, V>> iterator() {
        return this.root.cursor();
    }

    @Override
    public Cursor<K> keyIterator() {
        return Cursor.keys(this.root.cursor());
    }

    @Override
    public Cursor<V> valueIterator() {
        return Cursor.values(this.root.cursor());
    }

    public QTree<K, S, V> clone() {
        return this.copy(this.root);
    }

    protected QTree<K, S, V> copy(QTreePage<K, S, V> root) {
        return new QTree<K, S, V>(this.shapeForm, root);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof QTree) {
            QTree that = (QTree)other;
            if (this.size() == that.size()) {
                for (SpatialMap.Entry entry : that) {
                    V value = this.get(entry.getKey());
                    Object v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(QTree.class);
        }
        int a = 0;
        int b = 0;
        int c = 1;
        for (SpatialMap.Entry entry : this) {
            int h = Murmur3.mix((int)Murmur3.hash(entry.getKey()), (int)Murmur3.hash(entry.getValue()));
            a ^= h;
            b += h;
            if (h == 0) continue;
            c *= h;
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)a), (int)b), (int)c));
    }

    public void debug(Output<?> output) {
        output = output.write("QTree").write(46).write("empty").write(40).debug(this.shapeForm).write(41);
        for (SpatialMap.Entry entry : this) {
            output = output.write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getShape()).write(", ").debug(entry.getValue()).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <K, S, V> QTree<K, S, V> empty(Z2Form<S> shapeForm) {
        return new QTree<K, S, V>(shapeForm);
    }
}

