/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.header.Connection;
import swim.io.ConnectionContext;
import swim.io.FlowContext;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Socket;
import swim.io.http.HttpClient;
import swim.io.http.HttpClientContext;
import swim.io.http.HttpRequester;
import swim.io.http.HttpSettings;

public abstract class AbstractHttpClient
implements HttpClient,
ConnectionContext,
FlowContext {
    protected HttpClientContext context;

    @Override
    public HttpClientContext httpClientContext() {
        return this.context;
    }

    @Override
    public void setHttpClientContext(HttpClientContext context) {
        this.context = context;
    }

    @Override
    public long idleTimeout() {
        return -1L;
    }

    @Override
    public void willRequest(HttpRequest<?> request) {
    }

    @Override
    public void didRequest(HttpRequest<?> request) {
    }

    @Override
    public void willRespond(HttpResponse<?> response) {
    }

    @Override
    public void didRespond(HttpResponse<?> response) {
        Connection connection = (Connection)response.getHeader(Connection.class);
        if (connection != null) {
            if (connection.contains("close")) {
                this.close();
                return;
            }
            if (connection.contains("Upgrade")) {
                return;
            }
        }
        this.context.readResponse();
    }

    @Override
    public void willConnect() {
    }

    @Override
    public void didConnect() {
        this.context.readResponse();
    }

    @Override
    public void willSecure() {
    }

    @Override
    public void didSecure() {
    }

    @Override
    public void willBecome(Socket socket) {
    }

    @Override
    public void didBecome(Socket socket) {
    }

    @Override
    public void didTimeout() {
    }

    @Override
    public void didDisconnect() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public boolean isConnected() {
        return this.context.isConnected();
    }

    public boolean isClient() {
        return this.context.isClient();
    }

    public boolean isServer() {
        return this.context.isServer();
    }

    public boolean isSecure() {
        return this.context.isSecure();
    }

    public String securityProtocol() {
        return this.context.securityProtocol();
    }

    public String cipherSuite() {
        return this.context.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.context.localAddress();
    }

    public Principal localPrincipal() {
        return this.context.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.context.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.context.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.context.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.context.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.context.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.context.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.context.flowControl(flowModifier);
    }

    public HttpSettings httpSettings() {
        return this.context.httpSettings();
    }

    public void doRequest(HttpRequester<?> requester) {
        this.context.doRequest(requester);
    }

    public void readResponse() {
        this.context.readResponse();
    }

    public void become(Socket socket) {
        this.context.become(socket);
    }

    public void close() {
        this.context.close();
    }
}

