/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.codec.Decoder;
import swim.http.HttpException;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowControl;
import swim.io.FlowModifier;
import swim.io.Socket;
import swim.io.http.HttpClientModem;
import swim.io.http.HttpRequester;
import swim.io.http.HttpRequesterContext;
import swim.io.http.HttpSettings;

public class HttpClientRequester<T>
implements HttpRequesterContext {
    protected final HttpClientModem modem;
    protected final HttpRequester<T> requester;
    volatile HttpRequest<?> request;
    volatile int status;
    static final int REQUESTING = 1;
    static final int REQUESTED = 2;
    static final AtomicIntegerFieldUpdater<HttpClientRequester<?>> STATUS = AtomicIntegerFieldUpdater.newUpdater(HttpClientRequester.class, "status");

    public HttpClientRequester(HttpClientModem modem, HttpRequester<T> requester) {
        this.modem = modem;
        this.requester = requester;
    }

    public boolean isConnected() {
        return this.modem.isConnected();
    }

    public boolean isClient() {
        return this.modem.isClient();
    }

    public boolean isServer() {
        return this.modem.isServer();
    }

    public boolean isSecure() {
        return this.modem.isSecure();
    }

    public String securityProtocol() {
        return this.modem.securityProtocol();
    }

    public String cipherSuite() {
        return this.modem.cipherSuite();
    }

    public InetSocketAddress localAddress() {
        return this.modem.localAddress();
    }

    public Principal localPrincipal() {
        return this.modem.localPrincipal();
    }

    public Collection<Certificate> localCertificates() {
        return this.modem.localCertificates();
    }

    public InetSocketAddress remoteAddress() {
        return this.modem.remoteAddress();
    }

    public Principal remotePrincipal() {
        return this.modem.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificates() {
        return this.modem.remoteCertificates();
    }

    public FlowControl flowControl() {
        return this.modem.flowControl();
    }

    public void flowControl(FlowControl flowControl) {
        this.modem.flowControl(flowControl);
    }

    public FlowControl flowControl(FlowModifier flowModifier) {
        return this.modem.flowControl(flowModifier);
    }

    @Override
    public HttpSettings httpSettings() {
        return this.modem.httpSettings();
    }

    @Override
    public void writeRequest(HttpRequest<?> request) {
        block2: {
            int oldStatus;
            this.request = request;
            while (((oldStatus = STATUS.get(this)) & 2) == 0) {
                int newStatus = oldStatus | 2;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                if ((newStatus & 1) != 0) {
                    this.modem.doWriteRequest(request);
                }
                break block2;
            }
            throw new HttpException("already requested");
        }
    }

    void willRespond(HttpResponse<?> response) {
        this.requester.willRespond(response);
        Decoder<T> contentDecoder = this.requester.contentDecoder(response);
        Decoder entityDecoder = response.entityDecoder(contentDecoder);
        this.modem.doReadResponseEntity(entityDecoder);
    }

    void didRespond(HttpResponse<?> response) {
        this.requester.didRespond(response);
    }

    @Override
    public void become(Socket socket) {
        this.modem.become(socket);
    }

    @Override
    public void close() {
        this.modem.close();
    }

    void doRequest() {
        block2: {
            int oldStatus;
            this.requester.doRequest();
            while (((oldStatus = STATUS.get(this)) & 1) == 0) {
                int newStatus = oldStatus | 1;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                if ((newStatus & 2) != 0) {
                    this.modem.doWriteRequest(this.request);
                }
                break block2;
            }
            throw new AssertionError();
        }
    }

    void willRequest(HttpRequest<?> request) {
        this.requester.willRequest(request);
    }

    void didRequest(HttpRequest<?> request) {
        this.requester.didRequest(request);
    }

    void willBecome(Socket socket) {
        this.requester.willBecome(socket);
    }

    void didBecome(Socket socket) {
        this.requester.didBecome(socket);
    }

    void didDisconnect() {
        this.requester.didDisconnect();
    }

    void didTimeout() {
        this.requester.didTimeout();
    }

    void didFail(Throwable error) {
        this.requester.didFail(error);
    }
}

