/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.structure.Data;
import swim.util.Murmur3;
import swim.ws.WsControl;
import swim.ws.WsEncoder;
import swim.ws.WsOpcode;

public final class WsPong<P, T>
extends WsControl<P, T>
implements Debug {
    final P payload;
    final Encoder<?, ?> content;
    private static int hashSeed;

    WsPong(P payload, Encoder<?, ?> content) {
        this.payload = payload;
        this.content = content;
    }

    @Override
    public WsOpcode opcode() {
        return WsOpcode.PONG;
    }

    @Override
    public P payload() {
        return this.payload;
    }

    @Override
    public Encoder<?, ?> contentEncoder(WsEncoder ws) {
        return this.content;
    }

    @Override
    public Encoder<?, ?> encodeContent(OutputBuffer<?> output, WsEncoder ws) {
        return this.content.pull(output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsPong) {
            WsPong that = (WsPong)other;
            return this.payload == null ? that.payload == null : this.payload.equals(that.payload);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsPong.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.payload)));
    }

    public void debug(Output<?> output) {
        output = output.write("WsPong").write(46).write("from").write(40).debug(this.payload).write(", ").debug(this.content).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <P, T> WsPong<P, T> empty() {
        return new WsPong<Object, T>(null, Encoder.done());
    }

    public static <P, T> WsPong<P, T> from(P payload, Encoder<?, ?> content) {
        return new WsPong<P, T>(payload, content);
    }

    public static <P, T> WsPong<P, T> from(P payload) {
        if (payload instanceof Data) {
            return WsPong.from((Data)payload);
        }
        return new WsPong<P, T>(payload, Encoder.done());
    }

    public static <T> WsPong<ByteBuffer, T> from(ByteBuffer payload) {
        return new WsPong<ByteBuffer, T>(payload.duplicate(), (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)payload));
    }

    public static <T> WsPong<Data, T> from(Data payload) {
        return new WsPong<Data, T>(payload, (Encoder<?, ?>)payload.writer());
    }
}

