/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import swim.api.SwimLane;
import swim.api.SwimResident;
import swim.api.SwimTransient;
import swim.api.agent.AbstractAgentType;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentException;
import swim.api.lane.CommandLane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.JoinMapLane;
import swim.api.lane.JoinValueLane;
import swim.api.lane.Lane;
import swim.api.lane.ListLane;
import swim.api.lane.MapLane;
import swim.api.lane.SpatialLane;
import swim.api.lane.SupplyLane;
import swim.api.lane.ValueLane;
import swim.collections.HashTrieMap;
import swim.runtime.lane.CommandLaneView;
import swim.runtime.lane.DemandLaneView;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.lane.JoinMapLaneView;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.ListLaneView;
import swim.runtime.lane.MapLaneView;
import swim.runtime.lane.SpatialLaneView;
import swim.runtime.lane.SupplyLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

public abstract class AgentClass<A extends Agent>
extends AbstractAgentType<A> {
    final Class<? extends A> agentType;
    final Constructor<? extends A> constructor;

    AgentClass(Class<? extends A> agentType, Constructor<? extends A> constructor) {
        this.agentType = agentType;
        this.constructor = constructor;
        constructor.setAccessible(true);
    }

    public Class<? extends A> type() {
        return this.agentType;
    }

    public Value props(Uri nodeUri) {
        HashTrieMap params = this.route().unapply(nodeUri);
        Record props = Record.of();
        for (Map.Entry param : params) {
            props.slot((String)param.getKey(), (String)param.getValue());
        }
        return props;
    }

    public abstract A createAgent(AgentContext var1);

    public static <A extends Agent> AgentClass<A> apply(Class<? extends A> agentType) {
        try {
            return new ContextConstructor<A>(agentType, agentType.getDeclaredConstructor(AgentContext.class));
        }
        catch (NoSuchMethodException e) {
            try {
                return new NoArgConstructor<A>(agentType, agentType.getDeclaredConstructor(new Class[0]));
            }
            catch (NoSuchMethodException cause) {
                throw new AgentException((Throwable)cause);
            }
        }
    }

    static void reflectLaneFields(Class<?> agentType, AgentContext agentContext, Agent agent) {
        if (agentType != null) {
            Field[] fields;
            AgentClass.reflectLaneFields(agentType.getSuperclass(), agentContext, agent);
            for (Field field : fields = agentType.getDeclaredFields()) {
                if (!Lane.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                AgentClass.reflectLaneField(field, agentContext, agent);
            }
        }
    }

    static void reflectLaneField(Field field, AgentContext agentContext, Agent agent) {
        SwimLane swimLane = field.getAnnotation(SwimLane.class);
        if (swimLane != null) {
            Lane lane = AgentClass.reflectLaneType(agent, field, field.getGenericType());
            Uri laneUri = Uri.parse((String)swimLane.value());
            agentContext.openLane(laneUri, lane);
        }
    }

    static Lane reflectLaneType(Agent agent, Field field, Type type) {
        if (type instanceof ParameterizedType) {
            return AgentClass.reflectParameterizedLaneType(agent, field, (ParameterizedType)type);
        }
        return AgentClass.reflectOtherLaneType(agent, field, type);
    }

    static Lane reflectParameterizedLaneType(Agent agent, Field field, ParameterizedType type) {
        Type rawType = type.getRawType();
        if (rawType instanceof Class) {
            return AgentClass.reflectLaneTypeArguments(agent, field, (Class)rawType, type.getActualTypeArguments());
        }
        return AgentClass.reflectOtherLaneType(agent, field, type);
    }

    static Lane reflectLaneTypeArguments(Agent agent, Field field, Class<?> type, Type[] arguments) {
        if (CommandLane.class.equals(type)) {
            return AgentClass.reflectCommandLaneType(agent, field, type, arguments);
        }
        if (DemandLane.class.equals(type)) {
            return AgentClass.reflectDemandLaneType(agent, field, type, arguments);
        }
        if (DemandMapLane.class.equals(type)) {
            return AgentClass.reflectDemandMapLaneType(agent, field, type, arguments);
        }
        if (JoinMapLane.class.equals(type)) {
            return AgentClass.reflectJoinMapLaneType(agent, field, type, arguments);
        }
        if (JoinValueLane.class.equals(type)) {
            return AgentClass.reflectJoinValueLaneType(agent, field, type, arguments);
        }
        if (ListLane.class.equals(type)) {
            return AgentClass.reflectListLaneType(agent, field, type, arguments);
        }
        if (MapLane.class.equals(type)) {
            return AgentClass.reflectMapLaneType(agent, field, type, arguments);
        }
        if (SpatialLane.class.equals(type)) {
            return AgentClass.reflectSpatialLaneType(agent, field, type, arguments);
        }
        if (SupplyLane.class.equals(type)) {
            return AgentClass.reflectSupplyLaneType(agent, field, type, arguments);
        }
        if (ValueLane.class.equals(type)) {
            return AgentClass.reflectValueLaneType(agent, field, type, arguments);
        }
        return AgentClass.reflectOtherLaneType(agent, field, type);
    }

    static Lane reflectCommandLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().commandLane();
                field.set(agent, object);
            }
            if (object instanceof CommandLaneView) {
                CommandLaneView lane = (CommandLaneView)object;
                Form valueForm = lane.valueForm();
                Type valueType = arguments[0];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectDemandLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().demandLane();
                field.set(agent, object);
            }
            if (object instanceof DemandLaneView) {
                DemandLaneView lane = (DemandLaneView)object;
                Form valueForm = lane.valueForm();
                Type valueType = arguments[0];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectDemandMapLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().demandMapLane();
                field.set(agent, object);
            }
            if (object instanceof DemandMapLaneView) {
                DemandMapLaneView lane = (DemandMapLaneView)object;
                Form keyForm = lane.keyForm();
                Type keyType = arguments[0];
                if (keyForm == null && keyType instanceof Class) {
                    keyForm = Form.forClass((Class)((Class)keyType));
                    lane.setKeyForm(keyForm);
                }
                Form valueForm = lane.valueForm();
                Type valueType = arguments[1];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectJoinMapLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().joinMapLane();
                field.set(agent, object);
            }
            if (object instanceof JoinMapLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                JoinMapLaneView lane = (JoinMapLaneView)object;
                Form linkForm = lane.linkForm();
                Type linkType = arguments[0];
                if (linkForm == null && linkType instanceof Class) {
                    linkForm = Form.forClass((Class)((Class)linkType));
                    lane.setLinkForm(linkForm);
                }
                Form keyForm = lane.keyForm();
                Type keyType = arguments[1];
                if (keyForm == null && keyType instanceof Class) {
                    keyForm = Form.forClass((Class)((Class)keyType));
                    lane.setKeyForm(keyForm);
                }
                Form valueForm = lane.valueForm();
                Type valueType = arguments[2];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectJoinValueLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().joinValueLane();
                field.set(agent, object);
            }
            if (object instanceof JoinValueLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                JoinValueLaneView lane = (JoinValueLaneView)object;
                Form keyForm = lane.keyForm();
                Type keyType = arguments[0];
                if (keyForm == null && keyType instanceof Class) {
                    keyForm = Form.forClass((Class)((Class)keyType));
                    lane.setKeyForm(keyForm);
                }
                Form valueForm = lane.valueForm();
                Type valueType = arguments[1];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectListLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().listLane();
                field.set(agent, object);
            }
            if (object instanceof ListLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                ListLaneView lane = (ListLaneView)object;
                Form valueForm = lane.valueForm();
                Type valueType = arguments[0];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectMapLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().mapLane();
                field.set(agent, object);
            }
            if (object instanceof MapLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                MapLaneView lane = (MapLaneView)object;
                Form keyForm = lane.keyForm();
                Type keyType = arguments[0];
                if (keyForm == null && keyType instanceof Class) {
                    keyForm = Form.forClass((Class)((Class)keyType));
                    lane.setKeyForm(keyForm);
                }
                Form valueForm = lane.valueForm();
                Type valueType = arguments[1];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectSpatialLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().geospatialLane();
                field.set(agent, object);
            }
            if (object instanceof SpatialLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                SpatialLaneView lane = (SpatialLaneView)object;
                Form keyForm = lane.keyForm();
                Type keyType = arguments[0];
                if (keyForm == null && keyType instanceof Class) {
                    keyForm = Form.forClass((Class)((Class)keyType));
                    lane.setKeyForm(keyForm);
                }
                Form valueForm = lane.valueForm();
                Type valueType = arguments[2];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectSupplyLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().supplyLane();
                field.set(agent, object);
            }
            if (object instanceof SupplyLaneView) {
                SupplyLaneView lane = (SupplyLaneView)object;
                Form valueForm = lane.valueForm();
                Type valueType = arguments[0];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectValueLaneType(Agent agent, Field field, Class<?> type, Type[] arguments) {
        try {
            Object object = field.get(agent);
            if (object == null) {
                object = agent.agentContext().valueLane();
                field.set(agent, object);
            }
            if (object instanceof ValueLaneView) {
                SwimTransient swimTransient;
                SwimResident swimResident;
                ValueLaneView lane = (ValueLaneView)object;
                Form valueForm = lane.valueForm();
                Type valueType = arguments[0];
                if (valueForm == null && valueType instanceof Class) {
                    valueForm = Form.forClass((Class)((Class)valueType));
                    lane.setValueForm(valueForm);
                }
                if ((swimResident = field.getAnnotation(SwimResident.class)) != null) {
                    lane.isResident(swimResident.value());
                }
                if ((swimTransient = field.getAnnotation(SwimTransient.class)) != null) {
                    lane.isTransient(swimTransient.value());
                }
                return lane;
            }
            return AgentClass.reflectOtherLaneType(agent, field, type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static Lane reflectOtherLaneType(Agent agent, Field field, Type type) {
        try {
            Object object = field.get(agent);
            if (object instanceof Lane) {
                return (Lane)object;
            }
            throw new AgentException("unknown lane type: " + type);
        }
        catch (IllegalAccessException cause) {
            throw new AgentException((Throwable)cause);
        }
    }

    static final class NoArgConstructor<A extends Agent>
    extends AgentClass<A> {
        NoArgConstructor(Class<? extends A> agentType, Constructor<? extends A> constructor) {
            super(agentType, constructor);
        }

        @Override
        public A createAgent(AgentContext agentContext) {
            try {
                Agent agent = (Agent)this.constructor.newInstance(new Object[0]);
                NoArgConstructor.reflectLaneFields(this.agentType, agentContext, agent);
                return (A)agent;
            }
            catch (ReflectiveOperationException cause) {
                throw new AgentException((Throwable)cause);
            }
        }
    }

    static final class ContextConstructor<A extends Agent>
    extends AgentClass<A> {
        ContextConstructor(Class<? extends A> agentType, Constructor<? extends A> constructor) {
            super(agentType, constructor);
        }

        @Override
        public A createAgent(AgentContext agentContext) {
            try {
                Agent agent = (Agent)this.constructor.newInstance(agentContext);
                ContextConstructor.reflectLaneFields(this.agentType, agentContext, agent);
                return (A)agent;
            }
            catch (ReflectiveOperationException cause) {
                throw new AgentException((Throwable)cause);
            }
        }
    }
}

