/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.runtime.downlink.DemandDownlinkModem;
import swim.runtime.downlink.DownlinkView;
import swim.runtime.downlink.ValueDownlinkRelaySet;
import swim.runtime.downlink.ValueDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.EventMessage;

public class ValueDownlinkModel
extends DemandDownlinkModem<ValueDownlinkView<?>> {
    protected int flags = 0;
    protected volatile Value state;
    protected static final int STATEFUL = 1;
    static final AtomicReferenceFieldUpdater<ValueDownlinkModel, Value> STATE = AtomicReferenceFieldUpdater.newUpdater(ValueDownlinkModel.class, Value.class, "state");

    public ValueDownlinkModel(Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(meshUri, hostUri, nodeUri, laneUri, prio, rate, body);
    }

    public final boolean isStateful() {
        return (this.flags & 1) != 0;
    }

    public ValueDownlinkModel isStateful(boolean isStateful) {
        this.flags = isStateful ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof DownlinkView) {
            ((ValueDownlinkView)views).didSetStateful(isStateful);
        } else if (views instanceof DownlinkView[]) {
            DownlinkView[] viewArray = (DownlinkView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueDownlinkView)viewArray[i]).didSetStateful(isStateful);
            }
        }
        return this;
    }

    @Override
    protected void pushDownEvent(EventMessage message) {
        new ValueDownlinkRelaySet(this, message, message.body()).run();
    }

    @Override
    protected Value nextUpCue() {
        return this.state;
    }

    @Override
    protected void didAddDownlink(ValueDownlinkView<?> view) {
        if (this.views instanceof DownlinkView) {
            this.isStateful(view.isStateful());
        }
    }

    public Value get() {
        return this.state;
    }

    public <V> V set(ValueDownlinkView<V> view, V newObject) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ValueDownlinkRelaySet relay = new ValueDownlinkRelaySet(this, newValue);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = view.stage;
        relay.run();
        if (relay.isDone()) {
            if (relay.valueForm != valueForm && valueForm != null) {
                relay.oldObject = valueForm.cast((Item)relay.oldValue);
                if (relay.oldObject == null) {
                    relay.oldObject = valueForm.unit();
                }
            }
            return (V)relay.oldObject;
        }
        return null;
    }

    public Value setValue(Value newValue) {
        ValueDownlinkRelaySet relay = new ValueDownlinkRelaySet(this, newValue);
        relay.run();
        if (relay.isDone()) {
            return relay.oldValue;
        }
        return Value.absent();
    }

    protected Value willSet(Value newValue) {
        return newValue;
    }

    protected void didSet(Value newValue, Value oldValue) {
    }
}

