/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.agent.AgentContext;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.SupplyLane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.SupplyLaneModel;
import swim.structure.Form;

public class SupplyLaneView<V>
extends LaneView
implements SupplyLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected SupplyLaneModel laneBinding;

    public SupplyLaneView(AgentContext agentContext, Form<V> valueForm, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
    }

    public SupplyLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public SupplyLaneModel getLaneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(SupplyLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public SupplyLaneModel createLaneBinding() {
        return new SupplyLaneModel();
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> SupplyLaneView<V2> valueForm(Form<V2> valueForm) {
        return new SupplyLaneView<V2>(this.agentContext, valueForm, this.observers);
    }

    public <V2> SupplyLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    public final boolean isSigned() {
        return false;
    }

    public SupplyLaneView<V> isSigned(boolean isSigned) {
        return this;
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public SupplyLaneView<V> observe(Object observer) {
        return (SupplyLaneView)super.observe(observer);
    }

    @Override
    public SupplyLaneView<V> unobserve(Object observer) {
        return (SupplyLaneView)super.unobserve(observer);
    }

    @Override
    public SupplyLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public SupplyLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public SupplyLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public SupplyLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public SupplyLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public SupplyLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public SupplyLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public SupplyLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public SupplyLaneView<V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public SupplyLaneView<V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public SupplyLaneView<V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public SupplyLaneView<V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public SupplyLaneView<V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public SupplyLaneView<V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    public void push(V value) {
        this.laneBinding.sendDown(this.valueForm.mold(value).toValue());
    }
}

