/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.scope;

import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.downlink.EventDownlinkView;
import swim.runtime.downlink.MapDownlinkView;
import swim.runtime.downlink.ValueDownlinkView;
import swim.runtime.scope.LaneScope;
import swim.runtime.scope.Scope;
import swim.runtime.scope.ScopePushRequest;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;

public class NodeScope
extends Scope
implements NodeRef {
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;

    public NodeScope(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri) {
        super(cellContext, stage);
        this.meshUri = meshUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
    }

    @Override
    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public LaneRef laneRef(Uri laneUri) {
        return new LaneScope(this.cellContext, this.stage, this.meshUri, this.hostUri, this.nodeUri, laneUri);
    }

    public LaneRef laneRef(String laneUri) {
        return this.laneRef(Uri.parse((String)laneUri));
    }

    public EventDownlink<Value> downlink() {
        return new EventDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public ListDownlink<Value> downlinkList() {
        return null;
    }

    public MapDownlink<Value, Value> downlinkMap() {
        return new MapDownlinkView<Value, Value>((CellContext)this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue(), Form.forValue());
    }

    public ValueDownlink<Value> downlinkValue() {
        return new ValueDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public <T> HttpDownlink<T> downlinkHttp() {
        return null;
    }

    public void command(Uri laneUri, float prio, Value body) {
        CommandMessage message = new CommandMessage(this.nodeUri, laneUri, body);
        this.pushDown(new ScopePushRequest(this.meshUri, this.hostUri, null, (Envelope)message, prio));
    }

    public void command(String laneUri, float prio, Value body) {
        this.command(Uri.parse((String)laneUri), prio, body);
    }

    public void command(Uri laneUri, Value body) {
        this.command(laneUri, 0.0f, body);
    }

    public void command(String laneUri, Value body) {
        this.command(Uri.parse((String)laneUri), body);
    }
}

