/*
 * Decompiled with CFR 0.152.
 */
package swim.deflate;

final class CRC32 {
    static final int[] CRC_TABLE = CRC32.makeCRCTable();

    private CRC32() {
    }

    static int[] makeCRCTable() {
        int[] crcTable = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) != 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            crcTable[n] = c;
        }
        return crcTable;
    }

    static int crc32(int crc, byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return 0;
        }
        crc ^= 0xFFFFFFFF;
        while (length >= 8) {
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            length -= 8;
        }
        if (length != 0) {
            do {
                crc = CRC_TABLE[(crc ^ buffer[offset++]) & 0xFF] ^ crc >>> 8;
            } while (--length != 0);
        }
        return ~crc;
    }
}

