/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttEntity;
import swim.util.Murmur3;

public final class MqttValue<T>
extends MqttEntity<T>
implements Debug {
    final T value;
    private static int hashSeed;
    private static MqttValue<Object> empty;

    MqttValue(T value) {
        this.value = value;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public int mqttSize() {
        return -1;
    }

    @Override
    public Encoder<?, ?> mqttEncoder(MqttEncoder mqtt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder<?, ?> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttValue) {
            MqttValue that = (MqttValue)other;
            return this.value == null ? that.value == null : this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttValue.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttValue").write(46);
        output = this.value != null ? output.write("from").write(40).debug(this.value).write(41) : output.write("empty").write(40).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> MqttValue<T> empty() {
        if (empty == null) {
            empty = new MqttValue<Object>(null);
        }
        return empty;
    }

    public static <T> MqttValue<T> from(T value) {
        if (value == null) {
            return MqttValue.empty();
        }
        return new MqttValue<T>(value);
    }
}

