/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Output;
import swim.codec.Writer;
import swim.json.JsonWriter;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class JsonFormWriter<T>
extends Writer<T, T> {
    final JsonWriter<Item, Value> json;
    final Form<T> form;
    final T object;
    final Writer<?, ?> part;

    JsonFormWriter(JsonWriter<Item, Value> json, Form<T> form, T object, Writer<?, ?> part) {
        this.json = json;
        this.form = form;
        this.object = object;
        this.part = part;
    }

    JsonFormWriter(JsonWriter<Item, Value> json, Form<T> form) {
        this(json, form, null, null);
    }

    public Writer<T, T> feed(T object) {
        return new JsonFormWriter<T>(this.json, this.form, object, null);
    }

    public Writer<T, T> pull(Output<?> output) {
        return JsonFormWriter.write(output, this.json, this.form, this.object, this.part);
    }

    static <T> Writer<T, T> write(Output<?> output, JsonWriter<Item, Value> json, Form<T> form, T object, Writer<?, ?> part) {
        if (output == null) {
            return JsonFormWriter.done();
        }
        if (part == null) {
            Value value = form.mold(object).toValue();
            part = json.writeValue(value, output);
        } else {
            part = part.pull(output);
        }
        if (part.isDone()) {
            return JsonFormWriter.done(object);
        }
        if (part.isError()) {
            return part.asError();
        }
        return new JsonFormWriter<T>(json, form, object, part);
    }

    static <T> Writer<T, T> write(Output<T> output, JsonWriter<Item, Value> json, Form<T> form, T object) {
        return JsonFormWriter.write(output, json, form, object, null);
    }
}

