/*
 * Decompiled with CFR 0.152.
 */
package swim.concurrent;

import swim.concurrent.Schedule;
import swim.concurrent.Timer;
import swim.concurrent.TimerContext;
import swim.concurrent.TimerException;

public abstract class AbstractTimer
implements Timer {
    protected TimerContext timerContext;

    @Override
    public final TimerContext timerContext() {
        return this.timerContext;
    }

    @Override
    public void setTimerContext(TimerContext timerContext) {
        this.timerContext = timerContext;
    }

    @Override
    public abstract void runTimer();

    @Override
    public void timerWillSchedule(long millis) {
    }

    @Override
    public void timerDidCancel() {
    }

    public Schedule schedule() {
        TimerContext timerContext = this.timerContext;
        if (timerContext == null) {
            throw new TimerException("Unbound Timer");
        }
        return timerContext.schedule();
    }

    public boolean isScheduled() {
        TimerContext timerContext = this.timerContext;
        return timerContext != null && timerContext.isScheduled();
    }

    public void reschedule(long millis) {
        TimerContext timerContext = this.timerContext;
        if (timerContext == null) {
            throw new TimerException("Unbound Timer");
        }
        timerContext.reschedule(millis);
    }

    public boolean cancel() {
        TimerContext timerContext = this.timerContext;
        if (timerContext == null) {
            return false;
        }
        return timerContext.cancel();
    }
}

