/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class ByteWriter
extends Writer<Object, Object> {
    final Object value;
    final Input input;

    ByteWriter(Object value, Input input) {
        this.value = value;
        this.input = input;
    }

    ByteWriter(Object value, ByteBuffer input) {
        this(value, Binary.inputBuffer(input));
    }

    ByteWriter(Object value, byte[] input) {
        this(value, Binary.inputBuffer(input));
    }

    ByteWriter(Input input) {
        this(null, input);
    }

    ByteWriter(ByteBuffer input) {
        this(null, Binary.inputBuffer(input));
    }

    ByteWriter(byte[] input) {
        this(null, Binary.inputBuffer(input));
    }

    ByteWriter() {
        this(null, (Input)null);
    }

    @Override
    public Writer<Object, Object> feed(Object value) {
        if (value == null) {
            return ByteWriter.done();
        }
        if (value instanceof ByteBuffer) {
            return new ByteWriter(((ByteBuffer)value).duplicate());
        }
        if (value instanceof byte[]) {
            return new ByteWriter((byte[])value);
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return ByteWriter.write(output, this.value, this.input.clone());
    }

    static Writer<Object, Object> write(Output<?> output, Object value, Input input) {
        while (input.isCont() && output.isCont()) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.isDone() && !output.isError()) {
            return ByteWriter.done(value);
        }
        if (input.isError()) {
            return ByteWriter.error(input.trap());
        }
        if (output.isDone()) {
            return ByteWriter.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return ByteWriter.error(output.trap());
        }
        return new ByteWriter(value, input);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, ByteBuffer input) {
        return ByteWriter.write(output, value, Binary.inputBuffer(input));
    }

    static Writer<Object, Object> write(Output<?> output, Object value, byte[] input) {
        return ByteWriter.write(output, value, Binary.inputBuffer(input));
    }

    static Writer<Object, Object> write(Output<?> output, ByteBuffer input) {
        return ByteWriter.write(output, null, Binary.inputBuffer(input));
    }

    static Writer<Object, Object> write(Output<?> output, byte[] input) {
        return ByteWriter.write(output, null, Binary.inputBuffer(input));
    }
}

