/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Link;
import swim.api.data.MapData;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.runtime.CellContext;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.lane.JoinMapLaneDownlink;
import swim.runtime.lane.JoinMapLaneRelayClear;
import swim.runtime.lane.JoinMapLaneRelayDownlink;
import swim.runtime.lane.JoinMapLaneRelayRemove;
import swim.runtime.lane.JoinMapLaneRelayUpdate;
import swim.runtime.lane.JoinMapLaneUplink;
import swim.runtime.lane.JoinMapLaneView;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public class JoinMapLaneModel
extends LaneModel<JoinMapLaneView<?, ?, ?>, JoinMapLaneUplink> {
    protected int flags;
    protected MapData<Value, Value> data;
    protected MapData<Value, Value> linkData;
    protected volatile HashTrieMap<Value, JoinMapLaneDownlink<?, ?>> downlinks;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;
    static final AtomicReferenceFieldUpdater<JoinMapLaneModel, HashTrieMap<Value, JoinMapLaneDownlink<?, ?>>> DOWNLINKS = AtomicReferenceFieldUpdater.newUpdater(JoinMapLaneModel.class, HashTrieMap.class, "downlinks");

    JoinMapLaneModel(int flags) {
        this.flags = flags;
        this.downlinks = HashTrieMap.empty();
    }

    public JoinMapLaneModel() {
        this(0);
    }

    @Override
    protected JoinMapLaneUplink createUplink(LinkBinding link) {
        return new JoinMapLaneUplink(this, link);
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        super.setLaneContext(laneContext);
        this.openStore();
    }

    protected void openStore() {
        this.data = this.laneContext.store().mapData(this.laneUri().toString()).isResident(this.isResident()).isTransient(this.isTransient());
        this.linkData = this.laneContext.store().mapData((Value)Record.create((int)1).attr("join", this.laneUri().toString())).isResident(this.isResident()).isTransient(this.isTransient());
    }

    protected void openDownlinks() {
        for (Map.Entry entry : this.linkData) {
            Value key = (Value)entry.getKey();
            Value value = (Value)entry.getValue();
            Value header = value.header("downlink");
            Uri nodeUri = (Uri)header.get("node").coerce(Uri.form());
            Uri laneUri = (Uri)header.get("lane").coerce(Uri.form());
            float prio = header.get("prio").floatValue(0.0f);
            float rate = header.get("rate").floatValue(0.0f);
            Value body = header.get("body");
            new JoinMapLaneDownlink((CellContext)this.laneContext, this.stage(), this, key, this.laneContext.meshUri(), this.laneContext.hostUri(), nodeUri, laneUri, prio, rate, body, Form.forValue(), Form.forValue()).openDownlink();
        }
    }

    protected void downlink(Value key, JoinMapLaneDownlink<?, ?> downlink) {
        Value value = (Value)this.linkData.get((Object)key);
        Record header = value.headers("downlink");
        if (!(header != null && ((Uri)header.get("node").coerce(Uri.form())).equals((Object)downlink.nodeUri()) && ((Uri)header.get("lane").coerce(Uri.form())).equals((Object)downlink.laneUri()) && header.get("prio").floatValue(0.0f) == downlink.prio() && header.get("rate").floatValue(0.0f) == downlink.rate() && header.get("body").equals((Object)downlink.body()))) {
            header = Record.of().slot("node", downlink.nodeUri().toString()).slot("lane", downlink.laneUri().toString());
            if (downlink.prio() != 0.0f) {
                header.slot("prio", downlink.prio());
            }
            if (downlink.rate() != 0.0f) {
                header.slot("rate", downlink.rate());
            }
            if (downlink.body().isDefined()) {
                header.slot("body", downlink.body());
            }
            value = "downlink".equals(value.tag()) ? value.updatedAttr("downlink", (Value)header) : Record.of().attr("downlink", (Value)header).concat((Item)value);
            this.linkData.put((Object)key, (Object)value);
        }
        new JoinMapLaneRelayDownlink(this, key, downlink).run();
    }

    protected void openDownlink(Value key, JoinMapLaneDownlink<?, ?> downlink) {
        JoinMapLaneDownlink oldDownlink;
        HashTrieMap newDownlinks;
        HashTrieMap<Value, JoinMapLaneDownlink<?, ?>> oldDownlinks;
        downlink.openDownlink();
        while ((oldDownlinks = this.downlinks) != (newDownlinks = oldDownlinks.updated((Object)key, downlink)) && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (oldDownlinks != newDownlinks && (oldDownlink = (JoinMapLaneDownlink)oldDownlinks.get((Object)key)) != null) {
            try {
                oldDownlink.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void closeDownlinks() {
        HashTrieMap<Value, JoinMapLaneDownlink<?, ?>> oldDownlinks;
        HashTrieMap newDownlinks = HashTrieMap.empty();
        while ((oldDownlinks = this.downlinks) != newDownlinks && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (!oldDownlinks.isEmpty()) {
            for (JoinMapLaneDownlink downlink : oldDownlinks.values()) {
                try {
                    downlink.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void closeDownlinkKey(Value key) {
        HashTrieMap newDownlinks;
        HashTrieMap<Value, JoinMapLaneDownlink<?, ?>> oldDownlinks;
        while ((oldDownlinks = this.downlinks) != (newDownlinks = oldDownlinks.removed((Object)key)) && !DOWNLINKS.compareAndSet(this, oldDownlinks, newDownlinks)) {
        }
        if (oldDownlinks != newDownlinks) {
            JoinMapLaneDownlink downlink = (JoinMapLaneDownlink)oldDownlinks.get((Object)key);
            try {
                downlink.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void didOpenLaneView(JoinMapLaneView<?, ?, ?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            Value key = header.get("key");
            Value value = payload.body();
            new JoinMapLaneRelayUpdate(this, null, message, key, value).run();
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            Value key = header.get("key");
            new JoinMapLaneRelayRemove(this, null, message, key).run();
        } else if ("clear".equals(tag)) {
            new JoinMapLaneRelayClear(this, null, message).run();
        }
    }

    protected void cueDownKey(Value key) {
        FingerTrieSeq uplinks;
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                ((JoinMapLaneUplink)uplinks.get(i)).cueDownKey(key);
            }
        } while (uplinks != this.uplinks);
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public JoinMapLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        if (this.linkData != null) {
            this.linkData.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public JoinMapLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        if (this.linkData != null) {
            this.linkData.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public JoinMapLaneModel isSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        Object views = this.views;
        if (views instanceof JoinMapLaneView) {
            ((JoinMapLaneView)views).didSetSigned(isSigned);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((JoinMapLaneView)viewArray[i]).didSetSigned(isSigned);
            }
        }
        return this;
    }

    public Value get(Object key) {
        if (key != null) {
            return (Value)this.data.get(key);
        }
        return Value.absent();
    }

    public JoinMapLaneDownlink<?, ?> getDownlink(Object key) {
        return (JoinMapLaneDownlink)this.downlinks.get(key);
    }

    public void put(JoinMapLaneDownlink<?, ?> downlink, Value key, Value newValue) {
        JoinMapLaneRelayUpdate relay = new JoinMapLaneRelayUpdate(this, (Link)downlink, key, newValue);
        relay.run();
    }

    public <K, V> V put(JoinMapLaneView<?, K, V> view, K keyObject, V newObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        Value newValue = valueForm.mold(newObject).toValue();
        JoinMapLaneRelayUpdate relay = new JoinMapLaneRelayUpdate(this, null, key, newValue);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public void remove(JoinMapLaneDownlink<?, ?> downlink, Value key) {
        JoinMapLaneRelayRemove relay = new JoinMapLaneRelayRemove(this, (Link)downlink, key);
        relay.run();
    }

    public <K, V> V remove(JoinMapLaneView<?, K, V> view, K keyObject) {
        Form keyForm = view.keyForm;
        Form valueForm = view.valueForm;
        Value key = keyForm.mold(keyObject).toValue();
        JoinMapLaneRelayRemove relay = new JoinMapLaneRelayRemove(this, null, key);
        relay.keyForm = keyForm;
        relay.valueForm = valueForm;
        relay.keyObject = keyObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm == valueForm) {
            return (V)relay.oldObject;
        }
        return null;
    }

    public void clear(JoinMapLaneDownlink<?, ?> downlink) {
        JoinMapLaneRelayClear relay = new JoinMapLaneRelayClear(this, (Link)downlink);
        relay.run();
    }

    public void clear(JoinMapLaneView<?, ?, ?> view) {
        JoinMapLaneRelayClear relay = new JoinMapLaneRelayClear(this, null);
        relay.stage = this.stage();
        relay.run();
    }

    public Iterator<Map.Entry<Value, Value>> iterator() {
        return this.data.iterator();
    }

    @Override
    protected void willStart() {
        super.willStart();
        this.openDownlinks();
    }
}

