/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.auth.Identity;
import swim.api.http.HttpUplink;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.Lane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.api.uplink.Uplink;
import swim.codec.Decoder;
import swim.concurrent.Conts;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.runtime.LaneBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;

public abstract class LaneView
implements Lane {
    protected volatile Object observers;
    static final AtomicReferenceFieldUpdater<LaneView, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(LaneView.class, Object.class, "observers");

    public LaneView(Object observers) {
        this.observers = observers;
    }

    public abstract AgentContext agentContext();

    public abstract LaneBinding getLaneBinding();

    public abstract LaneBinding createLaneBinding();

    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final Uri hostUri() {
        return this.getLaneBinding().hostUri();
    }

    public final Uri nodeUri() {
        return this.getLaneBinding().nodeUri();
    }

    public final Uri laneUri() {
        return this.getLaneBinding().laneUri();
    }

    public abstract void close();

    public LaneView observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public LaneView unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    public abstract LaneView willCommand(WillCommand var1);

    public abstract LaneView didCommand(DidCommand var1);

    public abstract LaneView willUplink(WillUplink var1);

    public abstract LaneView didUplink(DidUplink var1);

    public abstract LaneView willEnter(WillEnter var1);

    public abstract LaneView didEnter(DidEnter var1);

    public abstract LaneView willLeave(WillLeave var1);

    public abstract LaneView didLeave(DidLeave var1);

    public abstract LaneView decodeRequest(DecodeRequestHttp<Object> var1);

    public abstract LaneView willRequest(WillRequestHttp<?> var1);

    public abstract LaneView didRequest(DidRequestHttp<Object> var1);

    public abstract LaneView doRespond(DoRespondHttp<Object> var1);

    public abstract LaneView willRespond(WillRespondHttp<?> var1);

    public abstract LaneView didRespond(DidRespondHttp<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillCommand(Value body, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillCommand)) break block12;
                        if (((WillCommand)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillCommand)observers).willCommand(body);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillCommand)) continue;
                        if (((WillCommand)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillCommand)observer).willCommand(body);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidCommand(Value body, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidCommand)) break block12;
                        if (((DidCommand)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidCommand)observers).didCommand(body);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidCommand)) continue;
                        if (((DidCommand)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidCommand)observer).didCommand(body);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillUplink(Uplink uplink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillUplink)) break block12;
                        if (((WillUplink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillUplink)observers).willUplink(uplink);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillUplink)) continue;
                        if (((WillUplink)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillUplink)observer).willUplink(uplink);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidUplink(Uplink uplink, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidUplink)) break block12;
                        if (((DidUplink)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidUplink)observers).didUplink(uplink);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidUplink)) continue;
                        if (((DidUplink)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidUplink)observer).didUplink(uplink);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillEnter(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillEnter)) break block12;
                        if (((WillEnter)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillEnter)observers).willEnter(identity);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillEnter)) continue;
                        if (((WillEnter)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillEnter)observer).willEnter(identity);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidEnter(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidEnter)) break block12;
                        if (((DidEnter)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidEnter)observers).didEnter(identity);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidEnter)) continue;
                        if (((DidEnter)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidEnter)observer).didEnter(identity);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillLeave(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillLeave)) break block12;
                        if (((WillLeave)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillLeave)observers).willLeave(identity);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillLeave)) continue;
                        if (((WillLeave)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillLeave)observer).willLeave(identity);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidLeave(Identity identity, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        SwimContext.setLane((Lane)this);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidLeave)) break block12;
                        if (((DidLeave)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidLeave)observers).didLeave(identity);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidLeave)) continue;
                        if (((DidLeave)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidLeave)observer).didLeave(identity);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Decoder<Object> dispatchDecodeRequest(HttpUplink uplink, HttpRequest<?> request) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            block15: {
                Object observers = this.observers;
                if (observers instanceof DecodeRequestHttp) {
                    try {
                        Decoder decoder = ((DecodeRequestHttp)observers).decodeRequest(request);
                        if (decoder != null) {
                            Decoder decoder2 = decoder;
                            return decoder2;
                        }
                        break block15;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                            break block15;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DecodeRequestHttp)) continue;
                        try {
                            Decoder decoder = ((DecodeRequestHttp)observer).decodeRequest(request);
                            if (decoder == null) continue;
                            Decoder decoder3 = decoder;
                            return decoder3;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            Decoder<Object> decoder = null;
            return decoder;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillRequest(HttpUplink uplink, HttpRequest<?> request, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillRequestHttp)) break block12;
                        if (((WillRequestHttp)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillRequestHttp)observers).willRequest(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillRequestHttp)) continue;
                        if (((WillRequestHttp)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillRequestHttp)observer).willRequest(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidRequest(HttpUplink uplink, HttpRequest<Object> request, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidRequestHttp)) break block12;
                        if (((DidRequestHttp)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidRequestHttp)observers).didRequest(request);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidRequestHttp)) continue;
                        if (((DidRequestHttp)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidRequestHttp)observer).didRequest(request);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object dispatchDoRespond(HttpUplink uplink, HttpRequest<Object> request, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block19: {
                Object observers = this.observers;
                complete = true;
                if (observers instanceof DoRespondHttp) {
                    if (((DoRespondHttp)observers).isPreemptive() == preemptive) {
                        try {
                            HttpResponse response = ((DoRespondHttp)observers).doRespond(request);
                            if (response != null) {
                                HttpResponse httpResponse = response;
                                return httpResponse;
                            }
                            break block19;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                                break block19;
                            }
                            throw error;
                        }
                    }
                    if (preemptive) {
                        complete = false;
                    }
                } else if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DoRespondHttp)) continue;
                        if (((DoRespondHttp)observer).isPreemptive() == preemptive) {
                            try {
                                HttpResponse response = ((DoRespondHttp)observer).doRespond(request);
                                if (response == null) continue;
                                HttpResponse httpResponse = response;
                                return httpResponse;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            Boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchWillRespond(HttpUplink uplink, HttpResponse<?> response, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof WillRespondHttp)) break block12;
                        if (((WillRespondHttp)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((WillRespondHttp)observers).willRespond(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof WillRespondHttp)) continue;
                        if (((WillRespondHttp)observer).isPreemptive() == preemptive) {
                            try {
                                ((WillRespondHttp)observer).willRespond(response);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchDidRespond(HttpUplink uplink, HttpResponse<?> response, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof DidRespondHttp)) break block12;
                        if (((DidRespondHttp)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((DidRespondHttp)observers).didRespond(response);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof DidRespondHttp)) continue;
                        if (((DidRespondHttp)observer).isPreemptive() == preemptive) {
                            try {
                                ((DidRespondHttp)observer).didRespond(response);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public void laneWillCommand(CommandMessage message) {
    }

    public void laneDidCommand(CommandMessage message) {
    }

    public void laneWillUplink(Uplink uplink) {
    }

    public void laneDidUplink(Uplink uplink) {
    }

    public void laneWillEnter(Identity identity) {
    }

    public void laneDidEnter(Identity identity) {
    }

    public void laneWillLeave(Identity identity) {
    }

    public void laneDidLeave(Identity identity) {
    }

    public Decoder<Object> laneDecodeRequest(HttpUplink uplink, HttpRequest<?> request) {
        return null;
    }

    public void laneWillRequest(HttpUplink uplink, HttpRequest<?> request) {
    }

    public void laneDidRequest(HttpUplink uplink, HttpRequest<Object> request) {
    }

    public HttpResponse<?> laneDoRespond(HttpUplink uplink, HttpRequest<Object> request) {
        return null;
    }

    public void laneWillRespond(HttpUplink uplink, HttpResponse<?> response) {
    }

    public void laneDidRespond(HttpUplink uplink, HttpResponse<?> response) {
    }

    public void laneDidFail(Throwable error) {
    }

    public void trace(Object message) {
        this.getLaneBinding().trace(message);
    }

    public void debug(Object message) {
        this.getLaneBinding().debug(message);
    }

    public void info(Object message) {
        this.getLaneBinding().info(message);
    }

    public void warn(Object message) {
        this.getLaneBinding().warn(message);
    }

    public void error(Object message) {
        this.getLaneBinding().error(message);
    }
}

