/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;

final class PayloadDecoder<V>
extends Decoder<V> {
    final ProtobufDecoder<?, V> protobuf;
    final Decoder<V> messageDecoder;
    final Decoder<V> textDecoder;
    final Decoder<V> dataDecoder;
    final int consumed;
    static final int DETECTION_WINDOW;
    static final Decoder<Object> DETECTION_FAILED;

    PayloadDecoder(ProtobufDecoder<?, V> protobuf, Decoder<V> messageDecoder, Decoder<V> textDecoder, Decoder<V> dataDecoder, int consumed) {
        this.protobuf = protobuf;
        this.messageDecoder = messageDecoder;
        this.textDecoder = textDecoder;
        this.dataDecoder = dataDecoder;
        this.consumed = consumed;
    }

    PayloadDecoder(ProtobufDecoder<?, V> protobuf) {
        this(protobuf, null, null, null, 0);
    }

    public Decoder<V> feed(InputBuffer input) {
        return PayloadDecoder.decode(input, this.protobuf, this.messageDecoder, this.textDecoder, this.dataDecoder, this.consumed);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf, Decoder<V> messageDecoder, Decoder<V> textDecoder, Decoder<V> dataDecoder, int consumed) {
        int inputStart = input.index();
        int inputLimit = input.limit();
        int inputRemaining = inputLimit - inputStart;
        int inputConsumed = 0;
        if (messageDecoder == null) {
            messageDecoder = protobuf.decodeMessage(input);
        } else if (messageDecoder.isCont()) {
            messageDecoder = messageDecoder.feed(input);
        }
        if (input.isDone() && messageDecoder.isDone()) {
            return messageDecoder;
        }
        if (consumed + (inputConsumed = Math.max(inputConsumed, input.index() - inputStart)) < DETECTION_WINDOW) {
            input = input.index(inputStart).limit(inputLimit);
            if (textDecoder == null) {
                textDecoder = protobuf.decodeText(input);
            } else if (textDecoder.isCont()) {
                textDecoder = textDecoder.feed(input);
            }
            if (input.isDone() && textDecoder.isDone()) {
                return textDecoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        } else {
            textDecoder = DETECTION_FAILED.asError();
        }
        if (consumed + inputConsumed < DETECTION_WINDOW) {
            input = input.index(inputStart).limit(inputLimit);
            if (dataDecoder == null) {
                dataDecoder = protobuf.decodeData(input);
            } else if (dataDecoder.isCont()) {
                dataDecoder = dataDecoder.feed(input);
            }
            if (input.isDone() && dataDecoder.isDone()) {
                return dataDecoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
        } else {
            dataDecoder = DETECTION_FAILED.asError();
        }
        if (textDecoder.isError() && dataDecoder.isError()) {
            return messageDecoder;
        }
        if (messageDecoder.isError() && dataDecoder.isError()) {
            return textDecoder;
        }
        if (messageDecoder.isError() && textDecoder.isError()) {
            return dataDecoder;
        }
        if (input.isDone()) {
            return PayloadDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return PayloadDecoder.error((Throwable)input.trap());
        }
        return new PayloadDecoder<V>(protobuf, messageDecoder, textDecoder, dataDecoder, consumed += inputConsumed);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf) {
        return PayloadDecoder.decode(input, protobuf, null, null, null, 0);
    }

    static {
        int detectionWindow;
        try {
            detectionWindow = Integer.parseInt(System.getProperty("swim.protobuf.payload.detection.window"));
        }
        catch (NumberFormatException e) {
            detectionWindow = 128;
        }
        DETECTION_WINDOW = detectionWindow;
        DETECTION_FAILED = PayloadDecoder.error((Throwable)new DecoderException("detection failed"));
    }
}

