/*
 * Decompiled with CFR 0.152.
 */
package swim.streamlet.combinator;

import java.util.Iterator;
import swim.collections.HashTrieMap;
import swim.streamlet.AbstractMapInoutlet;
import swim.streamlet.KeyEffect;
import swim.streamlet.MapOutlet;

public class MemoizeMapCombinator<K, V, IO>
extends AbstractMapInoutlet<K, V, V, IO, IO> {
    protected IO state = null;
    protected HashTrieMap<K, V> cache = HashTrieMap.empty();

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public IO get() {
        if (this.state == null && this.input != null) {
            this.state = this.input.get();
        }
        return this.state;
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.cache.keyIterator();
    }

    @Override
    protected void onReconcileKey(K key, KeyEffect effect, int version) {
        if (effect == KeyEffect.UPDATE) {
            if (this.input != null) {
                Object value = this.input.get(key);
                this.cache = value != null ? this.cache.updated(key, value) : this.cache.removed(key);
            }
        } else if (effect == KeyEffect.REMOVE) {
            this.cache = this.cache.removed(key);
        }
    }

    @Override
    protected void onReconcile(int version) {
        this.state = null;
    }

    @Override
    public MapOutlet<K, V, IO> memoize() {
        return this;
    }
}

