/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import swim.concurrent.Stage;
import swim.io.FlowControl;
import swim.io.Modem;
import swim.io.Service;
import swim.io.ServiceRef;
import swim.io.Socket;
import swim.io.SocketModem;
import swim.io.SocketRef;
import swim.io.SocketSettings;
import swim.io.Station;
import swim.io.StationException;
import swim.io.TcpService;
import swim.io.TcpSocket;
import swim.io.TlsService;
import swim.io.TlsSettings;
import swim.io.TlsSocket;

public class Endpoint {
    protected final Station station;
    protected SocketSettings socketSettings;

    public Endpoint(Station station, SocketSettings socketSettings) {
        this.station = station;
        this.socketSettings = socketSettings;
    }

    public Endpoint(Station station) {
        this(station, SocketSettings.standard());
    }

    public Endpoint(Stage stage, SocketSettings socketSettings) {
        this(new Station(stage), socketSettings);
    }

    public Endpoint(Stage stage) {
        this(new Station(stage), SocketSettings.standard());
    }

    public final SocketSettings socketSettings() {
        return this.socketSettings;
    }

    public final Stage stage() {
        return this.station.stage;
    }

    public final Station station() {
        return this.station;
    }

    public void start() {
        this.station.start();
    }

    public void stop() {
        this.station.stop();
    }

    public ServiceRef bindTcp(InetSocketAddress localAddress, Service service, SocketSettings socketSettings) {
        try {
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().setReuseAddress(true);
            serverChannel.socket().bind(localAddress, this.station.transportSettings.backlog);
            TcpService context = new TcpService(this.station, localAddress, serverChannel, service, socketSettings);
            service.setServiceContext(context);
            this.station.transport(context, FlowControl.ACCEPT);
            context.didBind();
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    public ServiceRef bindTcp(InetSocketAddress localAddress, Service service) {
        return this.bindTcp(localAddress, service, this.socketSettings);
    }

    public ServiceRef bindTcp(String address, int port, Service service, SocketSettings socketSettings) {
        return this.bindTcp(new InetSocketAddress(address, port), service, socketSettings);
    }

    public ServiceRef bindTcp(String address, int port, Service service) {
        return this.bindTcp(new InetSocketAddress(address, port), service, this.socketSettings);
    }

    public ServiceRef bindTls(InetSocketAddress localAddress, Service service, SocketSettings socketSettings) {
        try {
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            serverChannel.socket().setReuseAddress(true);
            serverChannel.socket().bind(localAddress, this.station.transportSettings.backlog);
            TlsService context = new TlsService(this.station, localAddress, serverChannel, service, socketSettings);
            service.setServiceContext(context);
            this.station.transport(context, FlowControl.ACCEPT);
            context.didBind();
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    public ServiceRef bindTls(InetSocketAddress localAddress, Service service) {
        return this.bindTls(localAddress, service, this.socketSettings);
    }

    public ServiceRef bindTls(String address, int port, Service service, SocketSettings socketSettings) {
        return this.bindTls(new InetSocketAddress(address, port), service, socketSettings);
    }

    public ServiceRef bindTls(String address, int port, Service service) {
        return this.bindTls(new InetSocketAddress(address, port), service, this.socketSettings);
    }

    public SocketRef connectTcp(InetSocketAddress remoteAddress, Socket socket, SocketSettings socketSettings) {
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            socketSettings.configure(channel.socket());
            boolean connected = channel.connect(remoteAddress);
            InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            TcpSocket context = new TcpSocket(localAddress, remoteAddress, channel, socketSettings, true);
            context.become(socket);
            if (connected) {
                this.station.transport(context, FlowControl.WAIT);
                context.didConnect();
            } else {
                context.willConnect();
                this.station.transport(context, FlowControl.CONNECT);
            }
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    public SocketRef connectTcp(InetSocketAddress remoteAddress, Socket socket) {
        return this.connectTcp(remoteAddress, socket, this.socketSettings);
    }

    public SocketRef connectTcp(String address, int port, Socket socket, SocketSettings socketSettings) {
        return this.connectTcp(new InetSocketAddress(address, port), socket, socketSettings);
    }

    public SocketRef connectTcp(String address, int port, Socket socket) {
        return this.connectTcp(new InetSocketAddress(address, port), socket, this.socketSettings);
    }

    public <I, O> SocketRef connectTcp(InetSocketAddress remoteAddress, Modem<I, O> modem, SocketSettings socketSettings) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTcp(remoteAddress, socket, socketSettings);
    }

    public <I, O> SocketRef connectTcp(InetSocketAddress remoteAddress, Modem<I, O> modem) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTcp(remoteAddress, socket, this.socketSettings);
    }

    public <I, O> SocketRef connectTcp(String address, int port, Modem<I, O> modem, SocketSettings socketSettings) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTcp(new InetSocketAddress(address, port), socket, socketSettings);
    }

    public <I, O> SocketRef connectTcp(String address, int port, Modem<I, O> modem) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTcp(new InetSocketAddress(address, port), socket, this.socketSettings);
    }

    public SocketRef connectTls(InetSocketAddress remoteAddress, Socket socket, SocketSettings socketSettings) {
        try {
            Collection<String> protocols;
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            socketSettings.configure(channel.socket());
            TlsSettings tlsSettings = socketSettings.tlsSettings();
            SSLEngine sslEngine = tlsSettings.sslContext().createSSLEngine();
            sslEngine.setUseClientMode(true);
            switch (tlsSettings.clientAuth()) {
                case NEED: {
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                case WANT: {
                    sslEngine.setWantClientAuth(true);
                    break;
                }
                case NONE: {
                    sslEngine.setWantClientAuth(false);
                    break;
                }
            }
            Collection<String> cipherSuites = tlsSettings.cipherSuites();
            if (cipherSuites != null) {
                sslEngine.setEnabledCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
            }
            if ((protocols = tlsSettings.protocols()) != null) {
                sslEngine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            }
            boolean connected = channel.connect(remoteAddress);
            InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            TlsSocket context = new TlsSocket(localAddress, remoteAddress, channel, sslEngine, socketSettings, true);
            context.become(socket);
            if (connected) {
                this.station.transport(context, FlowControl.WAIT);
                context.didConnect();
            } else {
                context.willConnect();
                this.station.transport(context, FlowControl.CONNECT);
            }
            return context;
        }
        catch (IOException error) {
            throw new StationException(error);
        }
    }

    public SocketRef connectTls(InetSocketAddress remoteAddress, Socket socket) {
        return this.connectTls(remoteAddress, socket, this.socketSettings);
    }

    public SocketRef connectTls(String address, int port, Socket socket, SocketSettings socketSettings) {
        return this.connectTls(new InetSocketAddress(address, port), socket, socketSettings);
    }

    public SocketRef connectTls(String address, int port, Socket socket) {
        return this.connectTls(new InetSocketAddress(address, port), socket, this.socketSettings);
    }

    public <I, O> SocketRef connectTls(InetSocketAddress remoteAddress, Modem<I, O> modem, SocketSettings socketSettings) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTls(remoteAddress, socket, socketSettings);
    }

    public <I, O> SocketRef connectTls(InetSocketAddress remoteAddress, Modem<I, O> modem) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTls(remoteAddress, socket, this.socketSettings);
    }

    public <I, O> SocketRef connectTls(String address, int port, Modem<I, O> modem, SocketSettings socketSettings) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTls(new InetSocketAddress(address, port), socket, socketSettings);
    }

    public <I, O> SocketRef connectTls(String address, int port, Modem<I, O> modem) {
        SocketModem<I, O> socket = new SocketModem<I, O>(modem);
        return this.connectTls(new InetSocketAddress(address, port), socket, this.socketSettings);
    }
}

