/*
 * Decompiled with CFR 0.152.
 */
package swim.io;

import java.net.Socket;
import java.net.SocketException;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.io.SocketSettingsForm;
import swim.io.TcpSettings;
import swim.io.TlsSettings;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class SocketSettings
implements Debug {
    protected final TcpSettings tcpSettings;
    protected final TlsSettings tlsSettings;
    private static int hashSeed;
    private static SocketSettings standard;
    private static Form<SocketSettings> form;

    public SocketSettings(TcpSettings tcpSettings, TlsSettings tlsSettings) {
        this.tcpSettings = tcpSettings;
        this.tlsSettings = tlsSettings;
    }

    public TcpSettings tcpSettings() {
        return this.tcpSettings;
    }

    public SocketSettings tcpSettings(TcpSettings tcpSettings) {
        return this.copy(tcpSettings, this.tlsSettings);
    }

    public TlsSettings tlsSettings() {
        return this.tlsSettings;
    }

    public SocketSettings tlsSettings(TlsSettings tlsSettings) {
        return this.copy(this.tcpSettings, tlsSettings);
    }

    protected SocketSettings copy(TcpSettings tcpSettings, TlsSettings tlsSettings) {
        return new SocketSettings(tcpSettings, tlsSettings);
    }

    public void configure(Socket socket) throws SocketException {
        this.tcpSettings.configure(socket);
    }

    public Value toValue() {
        return SocketSettings.form().mold((Object)this).toValue();
    }

    public boolean canEqual(Object other) {
        return other instanceof SocketSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SocketSettings) {
            SocketSettings that = (SocketSettings)other;
            return that.canEqual(this) && this.tcpSettings.equals(that.tcpSettings) && this.tlsSettings.equals(that.tlsSettings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SocketSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.tcpSettings.hashCode()), (int)this.tlsSettings.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("SocketSettings").write(46).write("standard").write(40).write(41).write(46).write("tcpSettings").write(40).debug((Object)this.tcpSettings).write(41).write(46).write("tlsSettings").write(40).debug((Object)this.tlsSettings).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static SocketSettings standard() {
        if (standard == null) {
            standard = new SocketSettings(TcpSettings.standard(), TlsSettings.standard());
        }
        return standard;
    }

    public static SocketSettings from(TcpSettings tcpSettings) {
        return new SocketSettings(tcpSettings, TlsSettings.standard());
    }

    public static SocketSettings from(TlsSettings tlsSettings) {
        return new SocketSettings(TcpSettings.standard(), tlsSettings);
    }

    @Kind
    public static Form<SocketSettings> form() {
        if (form == null) {
            form = new SocketSettingsForm();
        }
        return form;
    }
}

