/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.ws.WsEncoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

public final class WsFragment<T>
extends WsFrame<T>
implements Debug {
    final WsOpcode opcode;
    final Decoder<T> content;

    WsFragment(WsOpcode opcode, Decoder<T> content) {
        this.opcode = opcode;
        this.content = content;
    }

    @Override
    public boolean isDefined() {
        return false;
    }

    @Override
    public T get() {
        return (T)this.content.bind();
    }

    @Override
    public WsOpcode opcode() {
        return this.opcode;
    }

    @Override
    public Object payload() {
        return this.content.bind();
    }

    @Override
    public Encoder<?, ?> contentEncoder(WsEncoder ws) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder<?, ?> encodeContent(OutputBuffer<?> output, WsEncoder ws) {
        throw new UnsupportedOperationException();
    }

    public Decoder<T> contentDecoder() {
        return this.content;
    }

    public void debug(Output<?> output) {
        output = output.write("WsFragment").write(46).write("from").write(40).debug((Object)this.opcode).write(", ").debug(this.content).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> WsFragment<T> from(WsOpcode opcode, Decoder<T> content) {
        return new WsFragment<T>(opcode, content);
    }
}

