/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import swim.structure.Attr;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.RecordMap;
import swim.structure.Value;

final class RecordMapView
extends Record {
    RecordMap record;
    int lower;
    int upper;

    RecordMapView(RecordMap record, int lower, int upper) {
        this.record = record;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean isEmpty() {
        return this.lower == this.upper;
    }

    @Override
    public boolean isArray() {
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!(array[i] instanceof Field)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isObject() {
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!(array[i] instanceof Value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.upper - this.lower;
    }

    @Override
    public int fieldCount() {
        Item[] array = this.record.array;
        int k = 0;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!(array[i] instanceof Field)) continue;
            ++k;
        }
        return k;
    }

    @Override
    public int valueCount() {
        Item[] array = this.record.array;
        int k = 0;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!(array[i] instanceof Value)) continue;
            ++k;
        }
        return k;
    }

    @Override
    public boolean isConstant() {
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (array[i].isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String tag() {
        Item item;
        if (this.size() > 0 && (item = this.record.array[this.lower]) instanceof Attr) {
            return ((Attr)item).key.value;
        }
        return null;
    }

    @Override
    public Value target() {
        Value value = null;
        Record record = null;
        boolean modified = false;
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            Item item = array[i];
            if (item instanceof Attr) {
                modified = true;
                continue;
            }
            if (value == null && item instanceof Value) {
                value = (Value)item;
                continue;
            }
            if (record == null) {
                record = Record.create();
                if (value != null) {
                    record.add(value);
                }
            }
            record.add(item);
        }
        if (value == null) {
            return Value.extant();
        }
        if (record == null) {
            return value;
        }
        if (modified) {
            return record;
        }
        return this;
    }

    @Override
    public Item head() {
        if (this.size() > 0) {
            return this.record.array[this.lower];
        }
        return Item.absent();
    }

    @Override
    public Record tail() {
        if (this.size() > 0) {
            return new RecordMapView(this.record, this.lower + 1, this.upper);
        }
        return Record.empty();
    }

    @Override
    public Value body() {
        int n = this.size();
        if (n > 2) {
            return new RecordMapView(this.record, this.lower + 1, this.upper).branch();
        }
        if (n == 2) {
            Item item = this.record.array[this.lower + 1];
            if (item instanceof Value) {
                return (Value)item;
            }
            return Record.of((Object)item);
        }
        return Value.absent();
    }

    @Override
    public boolean contains(Item item) {
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!array[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        HashSet q = new HashSet(items);
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n && !q.isEmpty(); ++i) {
            q.remove(array[i]);
        }
        return q.isEmpty();
    }

    @Override
    public int indexOf(Object object) {
        Item item = Item.fromObject(object);
        Item[] array = this.record.array;
        int n = this.upper;
        for (int i = this.lower; i < n; ++i) {
            if (!array[i].equals(item)) continue;
            return i - this.lower;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Item item = Item.fromObject(object);
        Item[] array = this.record.array;
        for (int i = this.upper - 1; i >= this.lower; --i) {
            if (!array[i].equals(item)) continue;
            return i - this.lower;
        }
        return -1;
    }

    @Override
    public Item get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.record.array[this.lower + index];
    }

    @Override
    public Item getItem(int index) {
        if (index >= 0 && index < this.size()) {
            return this.record.array[this.lower + index];
        }
        return Item.absent();
    }

    @Override
    public Item setItem(int index, Item newItem) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.record.flags & 1) != 0) {
            return this.setItemAliased(index, newItem);
        }
        return this.setItemMutable(index, newItem);
    }

    private Item setItemAliased(int index, Item newItem) {
        int n = this.record.itemCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(n)];
        System.arraycopy(oldArray, 0, newArray, 0, n);
        Item oldItem = oldArray[this.lower + index];
        newArray[this.lower + index] = newItem;
        this.record.array = newArray;
        this.record.table = null;
        if (newItem instanceof Field) {
            if (!(oldItem instanceof Field)) {
                ++this.record.fieldCount;
            }
        } else if (oldItem instanceof Field) {
            --this.record.fieldCount;
        }
        FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
        return oldItem;
    }

    private Item setItemMutable(int index, Item newItem) {
        Item[] array = this.record.array;
        Item oldItem = array[this.lower + index];
        array[this.lower + index] = newItem;
        if (newItem instanceof Field) {
            this.record.table = null;
            if (!(oldItem instanceof Field)) {
                ++this.record.fieldCount;
            }
        } else if (oldItem instanceof Field) {
            this.record.table = null;
            --this.record.fieldCount;
        }
        return oldItem;
    }

    @Override
    public boolean add(Item newItem) {
        this.add(this.size(), newItem);
        return true;
    }

    @Override
    public void add(int index, Item newItem) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.record.flags & 1) != 0) {
            this.addAliased(index, newItem);
        } else {
            this.addMutable(index, newItem);
        }
    }

    private void addAliased(int index, Item newItem) {
        int n = this.record.itemCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(n + 1)];
        System.arraycopy(oldArray, 0, newArray, 0, this.lower + index);
        System.arraycopy(oldArray, this.lower + index, newArray, this.lower + index + 1, n - (this.lower + index));
        newArray[this.lower + index] = newItem;
        this.record.array = newArray;
        this.record.table = null;
        this.record.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.record.fieldCount;
        }
        FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
        ++this.upper;
    }

    private void addMutable(int index, Item newItem) {
        Item[] newArray;
        int n = this.record.itemCount;
        Item[] oldArray = this.record.array;
        if (n + 1 > oldArray.length) {
            newArray = new Item[RecordMapView.expand(n + 1)];
            System.arraycopy(oldArray, 0, newArray, 0, this.lower + index);
        } else {
            newArray = oldArray;
        }
        System.arraycopy(oldArray, this.lower + index, newArray, this.lower + index + 1, n - (this.lower + index));
        newArray[this.lower + index] = newItem;
        this.record.array = newArray;
        this.record.itemCount = n + 1;
        if (newItem instanceof Field) {
            ++this.record.fieldCount;
            this.record.table = null;
        }
        ++this.upper;
    }

    @Override
    public boolean addAll(Collection<? extends Item> newItems) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.record.flags & 1) != 0) {
            return this.addAllAliased(this.size(), newItems);
        }
        return this.addAllMutable(this.size(), newItems);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Item> newItems) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.record.flags & 1) != 0) {
            return this.addAllAliased(index, newItems);
        }
        return this.addAllMutable(index, newItems);
    }

    private boolean addAllAliased(int index, Collection<? extends Item> newItems) {
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(m + k)];
        if (oldArray != null) {
            System.arraycopy(oldArray, 0, newArray, 0, this.lower + index);
            System.arraycopy(oldArray, this.lower + index, newArray, this.lower + index + k, m - (this.lower + index));
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[this.lower + index] = newItem = iterator.next();
            ++index;
            if (!(newItem instanceof Field)) continue;
            ++n;
        }
        this.record.array = newArray;
        this.record.table = null;
        this.record.itemCount = m + k;
        this.record.fieldCount = n;
        FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
        this.upper += k;
        return true;
    }

    private boolean addAllMutable(int index, Collection<? extends Item> newItems) {
        Item[] newArray;
        int k = newItems.size();
        if (k == 0) {
            return false;
        }
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] oldArray = this.record.array;
        if (oldArray == null || m + k > oldArray.length) {
            newArray = new Item[RecordMapView.expand(m + k)];
            if (oldArray != null) {
                System.arraycopy(oldArray, 0, newArray, 0, this.lower + index);
            }
        } else {
            newArray = oldArray;
        }
        if (oldArray != null) {
            System.arraycopy(oldArray, this.lower + index, newArray, this.lower + index + k, m - (this.lower + index));
        }
        Iterator<? extends Item> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            Item newItem;
            newArray[this.lower + index] = newItem = iterator.next();
            ++index;
            if (!(newItem instanceof Field)) continue;
            ++n;
            this.record.table = null;
        }
        this.record.array = newArray;
        this.record.itemCount = m + k;
        this.record.fieldCount = n;
        this.upper += k;
        return true;
    }

    @Override
    public Item remove(int index) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if ((this.record.flags & 1) != 0) {
            return this.removeAliased(index);
        }
        return this.removeMutable(index);
    }

    private Item removeAliased(int index) {
        int n = this.record.itemCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(n - 1)];
        Item oldItem = oldArray[index];
        System.arraycopy(oldArray, 0, newArray, 0, this.lower + index);
        System.arraycopy(oldArray, this.lower + index + 1, newArray, this.lower + index, n - (this.lower + index) - 1);
        this.record.array = newArray;
        this.record.table = null;
        this.record.itemCount = n - 1;
        if (oldItem instanceof Field) {
            --this.record.fieldCount;
        }
        FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
        --this.upper;
        return oldItem;
    }

    private Item removeMutable(int index) {
        int n = this.record.itemCount;
        Item[] array = this.record.array;
        Item oldItem = array[this.lower + index];
        System.arraycopy(array, this.lower + index + 1, array, this.lower + index, n - (this.lower + index) - 1);
        array[n - 1] = null;
        this.record.itemCount = n - 1;
        if (oldItem instanceof Field) {
            --this.record.fieldCount;
            this.record.table = null;
        }
        --this.upper;
        return oldItem;
    }

    @Override
    public boolean remove(Object object) {
        Item item = Item.fromObject(object);
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.record.flags & 1) != 0) {
            return this.removeAllAliased(items);
        }
        return this.removeAllMutable(items);
    }

    private boolean removeAllAliased(Collection<?> items) {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(m)];
        int j = i = this.lower;
        int k = this.upper;
        System.arraycopy(oldArray, 0, newArray, 0, i);
        while (i < k) {
            Item item = oldArray[i];
            if (!items.contains(item)) {
                newArray[j] = item;
                ++j;
            } else if (item instanceof Field) {
                --n;
            }
            ++i;
        }
        if (i > j) {
            this.upper = j;
            while (i < m) {
                newArray[j] = oldArray[i];
                ++j;
                ++i;
            }
            this.record.array = newArray;
            this.record.table = null;
            this.record.itemCount = j;
            this.record.fieldCount = n;
            FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
            return true;
        }
        return false;
    }

    private boolean removeAllMutable(Collection<?> items) {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] array = this.record.array;
        int j = i = this.lower;
        int k = this.upper;
        while (i < k) {
            Item item = array[i];
            if (!items.contains(item)) {
                array[j] = item;
                ++j;
            } else if (item instanceof Field) {
                --n;
                this.record.table = null;
            }
            ++i;
        }
        this.upper = j;
        while (i < m) {
            array[j] = array[i];
            ++j;
            ++i;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.record.itemCount = j;
            this.record.fieldCount = n;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.record.flags & 1) != 0) {
            return this.retainAllAliased(items);
        }
        return this.retainAllMutable(items);
    }

    private boolean retainAllAliased(Collection<?> items) {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(m)];
        int j = i = this.lower;
        int k = this.upper;
        System.arraycopy(oldArray, 0, newArray, 0, i);
        while (i < k) {
            Item item = oldArray[i];
            if (items.contains(item)) {
                newArray[j] = item;
                ++j;
            } else if (item instanceof Field) {
                --n;
            }
            ++i;
        }
        if (i > j) {
            this.upper = j;
            while (i < m) {
                newArray[j] = oldArray[i];
                ++j;
                ++i;
            }
            this.record.array = newArray;
            this.record.table = null;
            this.record.itemCount = j;
            this.record.fieldCount = n;
            FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
            return true;
        }
        return false;
    }

    private boolean retainAllMutable(Collection<?> items) {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] array = this.record.array;
        int j = i = this.lower;
        int k = this.upper;
        while (i < k) {
            Item item = array[i];
            if (items.contains(item)) {
                array[j] = item;
                ++j;
            } else if (item instanceof Field) {
                --n;
                this.record.table = null;
            }
            ++i;
        }
        this.upper = j;
        while (i < m) {
            array[j] = array[i];
            ++j;
            ++i;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.record.itemCount = j;
            this.record.fieldCount = n;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if ((this.record.flags & 2) != 0) {
            throw new UnsupportedOperationException("immutable");
        }
        if ((this.record.flags & 1) != 0) {
            this.clearAliased();
        } else {
            this.clearMutable();
        }
    }

    private void clearAliased() {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        int l = m - this.size();
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(l)];
        System.arraycopy(oldArray, 0, newArray, 0, this.lower);
        for (i = this.lower; i < n; ++i) {
            if (!(oldArray[i] instanceof Field)) continue;
            --n;
        }
        i = this.lower;
        for (int j = this.upper; j < m; ++j) {
            newArray[i] = oldArray[j];
            ++i;
        }
        this.record.array = newArray;
        this.record.table = null;
        this.record.itemCount = l;
        this.record.fieldCount = n;
        FLAGS.set(this.record, this.record.flags & 0xFFFFFFFE);
        this.upper = this.lower;
    }

    private void clearMutable() {
        int i;
        int m = this.record.itemCount;
        int n = this.record.fieldCount;
        Item[] array = this.record.array;
        for (i = this.lower; i < n; ++i) {
            if (!(array[i] instanceof Field)) continue;
            --n;
        }
        i = this.lower;
        for (int j = this.upper; j < m; ++j) {
            Item item = array[j];
            if (item instanceof Field) {
                this.record.table = null;
            }
            array[i] = item;
            ++i;
        }
        this.record.itemCount = i;
        this.record.fieldCount = n;
        while (i < m) {
            array[i] = null;
            ++i;
        }
        this.upper = this.lower;
    }

    @Override
    public boolean isAliased() {
        return (this.record.flags & 1) != 0;
    }

    @Override
    public boolean isMutable() {
        return (this.record.flags & 2) == 0;
    }

    @Override
    public void alias() {
        FLAGS.set(this.record, this.record.flags | 1);
    }

    @Override
    public Record branch() {
        int m = this.size();
        int n = 0;
        Item[] oldArray = this.record.array;
        Item[] newArray = new Item[RecordMapView.expand(m)];
        int i = this.lower;
        for (int j = 0; j < m; ++j) {
            Item item;
            newArray[j] = item = oldArray[i];
            if (item instanceof Field) {
                ++n;
            }
            ++i;
        }
        return new RecordMap(newArray, null, m, n, 0);
    }

    @Override
    public Record commit() {
        this.record.commit();
        return this;
    }

    @Override
    public Item[] toArray() {
        int n = this.size();
        Item[] array = new Item[n];
        System.arraycopy(this.record.array, this.lower, array, 0, n);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.size();
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        System.arraycopy(this.record.array, this.lower, array, 0, n);
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public Record subList(int lower, int upper) {
        if (lower < 0 || upper > this.size() || lower > upper) {
            throw new IndexOutOfBoundsException(lower + ", " + upper);
        }
        return new RecordMapView(this.record, this.lower + lower, this.lower + upper);
    }
}

