/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.collections;

import java.util.AbstractMap;
import java.util.ListIterator;
import java.util.Map;
import swim.structure.Form;
import swim.structure.Value;

final class ValueKeyedListEntryIterator<T>
implements ListIterator<Map.Entry<Object, T>> {
    final ListIterator<Map.Entry<Object, Value>> inner;
    final Form<T> valueForm;

    ValueKeyedListEntryIterator(ListIterator<Map.Entry<Object, Value>> inner, Form<T> valueForm) {
        this.inner = inner;
        this.valueForm = valueForm;
    }

    @Override
    public boolean hasNext() {
        return this.inner.hasNext();
    }

    @Override
    public int nextIndex() {
        return this.inner.nextIndex();
    }

    @Override
    public Map.Entry<Object, T> next() {
        Map.Entry<Object, Value> next = this.inner.next();
        Object nextKey = next.getKey();
        T nextObject = this.valueForm.cast(next.getValue());
        return new AbstractMap.SimpleImmutableEntry<Object, T>(nextKey, nextObject);
    }

    @Override
    public boolean hasPrevious() {
        return this.inner.hasPrevious();
    }

    @Override
    public int previousIndex() {
        return this.inner.previousIndex();
    }

    @Override
    public Map.Entry<Object, T> previous() {
        Map.Entry<Object, Value> previous = this.inner.previous();
        Object previousKey = previous.getKey();
        T previousObject = this.valueForm.cast(previous.getValue());
        return new AbstractMap.SimpleImmutableEntry<Object, T>(previousKey, previousObject);
    }

    @Override
    public void add(Map.Entry<Object, T> newEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(Map.Entry<Object, T> newEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        this.inner.remove();
    }
}

