/*
 * Decompiled with CFR 0.152.
 */
package swim.io.http;

import swim.io.SocketSettings;
import swim.io.http.HttpSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class HttpSettingsForm
extends Form<HttpSettings> {
    HttpSettingsForm() {
    }

    public HttpSettings unit() {
        return HttpSettings.standard();
    }

    public Class<?> type() {
        return HttpSettings.class;
    }

    public Item mold(HttpSettings settings) {
        if (settings != null) {
            HttpSettings standard = HttpSettings.standard();
            Record http = Record.create((int)2).attr("http");
            if (settings.maxMessageSize != standard.maxMessageSize) {
                http.slot("maxMessageSize", settings.maxMessageSize);
            }
            return Record.of((Object)http).concat(SocketSettings.form().mold((Object)settings.socketSettings));
        }
        return Item.extant();
    }

    public HttpSettings cast(Item item) {
        Value value = item.toValue();
        HttpSettings standard = HttpSettings.standard();
        int maxMessageSize = standard.maxMessageSize;
        for (Item member : value) {
            if (!member.getAttr("http").isDefined()) continue;
            maxMessageSize = member.get("maxMessageSize").intValue(maxMessageSize);
        }
        SocketSettings socketSettings = (SocketSettings)SocketSettings.form().cast(item);
        return new HttpSettings(socketSettings, maxMessageSize);
    }
}

