/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.collections.HashTrieSet;
import swim.concurrent.PullRequest;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.Socket;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.remote.RemoteCredentials;
import swim.remote.RemoteHostDownlink;
import swim.remote.RemoteHostPushDown;
import swim.remote.RemoteHostPushUp;
import swim.remote.RemoteHostUplink;
import swim.remote.Unauthenticated;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HttpBinding;
import swim.runtime.HttpContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.NodeBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.uplink.HttpErrorUplinkModem;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriHost;
import swim.uri.UriPath;
import swim.uri.UriPort;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.util.HashGenCacheMap;
import swim.warp.AuthRequest;
import swim.warp.AuthedResponse;
import swim.warp.CommandMessage;
import swim.warp.DeauthRequest;
import swim.warp.DeauthedResponse;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LaneAddressed;
import swim.warp.LinkAddressed;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;
import swim.ws.WsClose;
import swim.ws.WsControl;
import swim.ws.WsPing;
import swim.ws.WsPong;

public class RemoteHost
extends AbstractTierBinding
implements HostBinding,
WarpSocket {
    protected HostContext hostContext;
    protected WarpSocketContext warpSocketContext;
    final Uri requestUri;
    final Uri baseUri;
    Uri remoteUri;
    volatile int flags;
    volatile Identity remoteIdentity;
    volatile HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>> downlinks;
    volatile HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>> uplinks;
    final HashGenCacheMap<Uri, Uri> resolveCache;
    static final int PRIMARY = 1;
    static final int REPLICA = 2;
    static final int MASTER = 4;
    static final int SLAVE = 8;
    static final int URI_RESOLUTION_CACHE_SIZE;
    static final AtomicIntegerFieldUpdater<RemoteHost> FLAGS;
    static final AtomicReferenceFieldUpdater<RemoteHost, Identity> REMOTE_IDENTITY;
    static final AtomicReferenceFieldUpdater<RemoteHost, HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>> DOWNLINKS;
    static final AtomicReferenceFieldUpdater<RemoteHost, HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>> UPLINKS;

    public RemoteHost(Uri requestUri, Uri baseUri) {
        this.requestUri = requestUri;
        this.baseUri = baseUri;
        this.downlinks = HashTrieMap.empty();
        this.uplinks = HashTrieMap.empty();
        this.resolveCache = new HashGenCacheMap(URI_RESOLUTION_CACHE_SIZE);
    }

    public RemoteHost(Uri baseUri) {
        this(Uri.empty(), baseUri);
    }

    public final TierContext tierContext() {
        return this.hostContext;
    }

    public final HostContext hostContext() {
        return this.hostContext;
    }

    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    public WarpSocketContext warpSocketContext() {
        return this.warpSocketContext;
    }

    public void setWarpSocketContext(WarpSocketContext warpSocketContext) {
        this.warpSocketContext = warpSocketContext;
    }

    public long idleTimeout() {
        return -1L;
    }

    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return null;
    }

    public Uri meshUri() {
        return this.hostContext.meshUri();
    }

    public Value partKey() {
        return this.hostContext.partKey();
    }

    public Uri hostUri() {
        return this.hostContext.hostUri();
    }

    public Policy policy() {
        return this.hostContext.policy();
    }

    public Schedule schedule() {
        return this.hostContext.schedule();
    }

    public Stage stage() {
        return this.hostContext.stage();
    }

    public StoreBinding store() {
        return this.hostContext.store();
    }

    public boolean isConnected() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        return warpSocketContext != null && warpSocketContext.isConnected();
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isSecure() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        return warpSocketContext != null && warpSocketContext.isSecure();
    }

    public String securityProtocol() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.securityProtocol();
        }
        return null;
    }

    public String cipherSuite() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.cipherSuite();
        }
        return null;
    }

    public InetSocketAddress localAddress() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localAddress();
        }
        return null;
    }

    public Identity localIdentity() {
        return null;
    }

    public Principal localPrincipal() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localPrincipal();
        }
        return null;
    }

    public Collection<Certificate> localCertificates() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public InetSocketAddress remoteAddress() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remoteAddress();
        }
        return null;
    }

    public Identity remoteIdentity() {
        return this.remoteIdentity;
    }

    public Principal remotePrincipal() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remotePrincipal();
        }
        return null;
    }

    public Collection<Certificate> remoteCertificates() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remoteCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public boolean isPrimary() {
        return (this.flags & 1) != 0;
    }

    public void setPrimary(boolean isPrimary) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 1) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    public boolean isReplica() {
        return (this.flags & 2) != 0;
    }

    public void setReplica(boolean isReplica) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 2) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    public boolean isMaster() {
        return (this.flags & 4) != 0;
    }

    public boolean isSlave() {
        return (this.flags & 8) != 0;
    }

    public void didBecomeMaster() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFF7 | 4) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    public void didBecomeSlave() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFFB | 8) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    RemoteHostDownlink createDownlink(Uri remoteNodeUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        return new RemoteHostDownlink(this, remoteNodeUri, nodeUri, laneUri, prio, rate, body);
    }

    RemoteHostUplink createUplink(LinkBinding link, Uri remoteNodeUri) {
        return new RemoteHostUplink(this, link, remoteNodeUri);
    }

    PushRequest createPushRequest(Envelope envelope, float prio) {
        return new RemoteHostPushDown(this, envelope, prio);
    }

    PullRequest<Envelope> createPullEnvelope(Envelope envelope, float prio, PushRequest delegate) {
        return new RemoteHostPushUp(this, envelope, prio, delegate);
    }

    protected Uri resolve(Uri relativeUri) {
        Uri absoluteUri = (Uri)this.resolveCache.get((Object)relativeUri);
        if (absoluteUri == null) {
            absoluteUri = this.baseUri.resolve(relativeUri);
            if (!relativeUri.authority().isDefined()) {
                absoluteUri = Uri.from((UriScheme)relativeUri.scheme(), (UriAuthority)UriAuthority.undefined(), (UriPath)absoluteUri.path(), (UriQuery)absoluteUri.query(), (UriFragment)absoluteUri.fragment());
            }
            absoluteUri = (Uri)this.resolveCache.put((Object)relativeUri, (Object)absoluteUri);
        }
        return absoluteUri;
    }

    public HashTrieMap<Uri, NodeBinding> getNodes() {
        return HashTrieMap.empty();
    }

    public NodeBinding getNode(Uri nodeUri) {
        return null;
    }

    public NodeBinding openNode(Uri nodeUri) {
        return null;
    }

    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        return null;
    }

    public void openUplink(LinkBinding link) {
        HashTrieSet laneUplinks;
        HashTrieMap nodeUplinks;
        HashTrieMap newUplinks;
        HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>> oldUplinks;
        Uri laneUri = link.laneUri();
        Uri remoteNodeUri = this.resolve(link.nodeUri());
        RemoteHostUplink uplink = this.createUplink(link, remoteNodeUri);
        link.setLinkContext((LinkContext)uplink);
        do {
            if ((nodeUplinks = (HashTrieMap)(oldUplinks = this.uplinks).get((Object)remoteNodeUri)) == null) {
                nodeUplinks = HashTrieMap.empty();
            }
            if ((laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) continue;
            laneUplinks = HashTrieSet.empty();
        } while (!UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)(newUplinks = oldUplinks.updated((Object)remoteNodeUri, (Object)(nodeUplinks = nodeUplinks.updated((Object)laneUri, (Object)(laneUplinks = laneUplinks.added((Object)uplink))))))));
        if (this.warpSocketContext.isConnected()) {
            uplink.didConnect();
        }
    }

    void closeUplink(RemoteHostUplink uplink) {
        HashTrieMap newUplinks;
        HashTrieMap oldUplinks;
        Uri laneUri = uplink.laneUri();
        Uri remoteNodeUri = uplink.remoteNodeUri;
        do {
            HashTrieMap nodeUplinks;
            if ((nodeUplinks = (HashTrieMap)(oldUplinks = this.uplinks).get((Object)remoteNodeUri)) != null) {
                HashTrieSet laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri);
                if (laneUplinks != null) {
                    if ((laneUplinks = laneUplinks.removed((Object)uplink)).isEmpty()) {
                        if ((nodeUplinks = nodeUplinks.removed((Object)laneUri)).isEmpty()) {
                            newUplinks = oldUplinks.removed((Object)remoteNodeUri);
                            continue;
                        }
                        newUplinks = oldUplinks.updated((Object)remoteNodeUri, (Object)nodeUplinks);
                        continue;
                    }
                    nodeUplinks = nodeUplinks.updated((Object)laneUri, (Object)laneUplinks);
                    newUplinks = oldUplinks.updated((Object)remoteNodeUri, (Object)nodeUplinks);
                    continue;
                }
                newUplinks = oldUplinks;
                break;
            }
            newUplinks = oldUplinks;
            break;
        } while (oldUplinks != newUplinks && !UPLINKS.compareAndSet(this, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)newUplinks));
        if (oldUplinks != newUplinks) {
            uplink.didCloseUp();
        }
    }

    public void httpUplink(HttpBinding http) {
        HttpErrorUplinkModem httpContext = new HttpErrorUplinkModem(http);
        http.setHttpContext((HttpContext)httpContext);
    }

    public void pushUp(PushRequest pushRequest) {
        Envelope envelope = pushRequest.envelope();
        float prio = pushRequest.prio();
        Uri remoteNodeUri = this.resolve(envelope.nodeUri());
        Envelope remoteEnvelope = envelope.nodeUri(remoteNodeUri);
        PullRequest<Envelope> pullEnvelope = this.createPullEnvelope(remoteEnvelope, prio, pushRequest);
        this.warpSocketContext.feed(pullEnvelope);
    }

    public void willConnect() {
    }

    public void didConnect() {
        InetSocketAddress remoteAddress = this.warpSocketContext.remoteAddress();
        UriAuthority remoteAuthority = UriAuthority.from((UriHost)UriHost.inetAddress((InetAddress)remoteAddress.getAddress()), (UriPort)UriPort.from((int)remoteAddress.getPort()));
        this.remoteUri = Uri.from((UriScheme)UriScheme.from((String)"warp"), (UriAuthority)remoteAuthority, (UriPath)UriPath.slash());
        REMOTE_IDENTITY.set(this, new Unauthenticated(this.requestUri, this.remoteUri, Value.absent()));
        this.connectUplinks();
        this.hostContext.didConnect();
    }

    public void willSecure() {
    }

    public void didSecure() {
    }

    public void willBecome(Socket socket) {
    }

    public void didBecome(Socket socket) {
    }

    public void didUpgrade(HttpRequest<?> request, HttpResponse<?> response) {
        this.start();
    }

    public void doRead() {
    }

    public void didRead(Envelope envelope) {
        if (envelope instanceof EventMessage) {
            this.onEventMessage((EventMessage)envelope);
        } else if (envelope instanceof CommandMessage) {
            this.onCommandMessage((CommandMessage)envelope);
        } else if (envelope instanceof LinkRequest) {
            this.onLinkRequest((LinkRequest)envelope);
        } else if (envelope instanceof LinkedResponse) {
            this.onLinkedResponse((LinkedResponse)envelope);
        } else if (envelope instanceof SyncRequest) {
            this.onSyncRequest((SyncRequest)envelope);
        } else if (envelope instanceof SyncedResponse) {
            this.onSyncedResponse((SyncedResponse)envelope);
        } else if (envelope instanceof UnlinkRequest) {
            this.onUnlinkRequest((UnlinkRequest)envelope);
        } else if (envelope instanceof UnlinkedResponse) {
            this.onUnlinkedResponse((UnlinkedResponse)envelope);
        } else if (envelope instanceof AuthRequest) {
            this.onAuthRequest((AuthRequest)envelope);
        } else if (envelope instanceof AuthedResponse) {
            this.onAuthedResponse((AuthedResponse)envelope);
        } else if (envelope instanceof DeauthRequest) {
            this.onDeauthRequest((DeauthRequest)envelope);
        } else if (envelope instanceof DeauthedResponse) {
            this.onDeauthedResponse((DeauthedResponse)envelope);
        } else {
            this.onUnknownEnvelope(envelope);
        }
    }

    public void didRead(WsControl<?, ?> frame) {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (frame instanceof WsClose) {
            if (warpSocketContext != null) {
                warpSocketContext.write((WsControl)WsClose.from((int)1000));
            } else {
                this.close();
            }
        } else if (frame instanceof WsPing && warpSocketContext != null) {
            warpSocketContext.write((WsControl)WsPong.from((Object)frame.payload()));
        }
    }

    protected void onEventMessage(EventMessage message) {
        HashTrieSet laneUplinks;
        Uri nodeUri = this.resolve(message.nodeUri());
        Uri laneUri = message.laneUri();
        HashTrieMap nodeUplinks = (HashTrieMap)this.uplinks.get((Object)nodeUri);
        if (nodeUplinks != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            EventMessage resolvedMessage = message.nodeUri(nodeUri);
            Iterator uplinksIterator = laneUplinks.iterator();
            while (uplinksIterator.hasNext()) {
                ((RemoteHostUplink)uplinksIterator.next()).queueDown((Envelope)resolvedMessage);
            }
        }
    }

    protected void onCommandMessage(CommandMessage message) {
        RemoteHostDownlink laneDownlink;
        Policy policy = this.policy();
        if (policy != null) {
            PolicyDirective directive = policy.canDownlink(message, this.remoteIdentity);
            if (directive.isAllowed()) {
                CommandMessage newMessage = (CommandMessage)directive.get();
                if (newMessage != null) {
                    message = newMessage;
                }
            } else {
                if (directive.isDenied()) {
                    return;
                }
                this.forbid();
                return;
            }
        }
        Uri nodeUri = this.resolve(message.nodeUri());
        Uri laneUri = message.laneUri();
        CommandMessage resolvedMessage = message.nodeUri(nodeUri);
        HashTrieMap nodeDownlinks = (HashTrieMap)this.downlinks.get((Object)nodeUri);
        if (nodeDownlinks != null && (laneDownlink = (RemoteHostDownlink)nodeDownlinks.get((Object)laneUri)) != null) {
            laneDownlink.queueUp((Envelope)resolvedMessage);
            return;
        }
        PushRequest pushRequest = this.createPushRequest((Envelope)resolvedMessage, 0.0f);
        this.hostContext.pushDown(pushRequest);
    }

    protected void routeDownlink(LinkAddressed envelope) {
        HashTrieMap nodeDownlinks;
        HashTrieMap newDownlinks;
        HashTrieMap oldDownlinks;
        Uri remoteNodeUri = envelope.nodeUri();
        Uri nodeUri = this.resolve(remoteNodeUri);
        Uri laneUri = envelope.laneUri();
        float prio = envelope.prio();
        float rate = envelope.rate();
        Value body = envelope.body();
        RemoteHostDownlink downlink = null;
        do {
            RemoteHostDownlink laneDownlink;
            if ((nodeDownlinks = (HashTrieMap)(oldDownlinks = this.downlinks).get((Object)nodeUri)) == null) {
                nodeDownlinks = HashTrieMap.empty();
            }
            if ((laneDownlink = (RemoteHostDownlink)nodeDownlinks.get((Object)laneUri)) != null) {
                if (downlink != null) {
                    downlink.closeDown();
                }
                downlink = laneDownlink;
                newDownlinks = oldDownlinks;
                break;
            }
            if (downlink != null) continue;
            downlink = this.createDownlink(remoteNodeUri, nodeUri, laneUri, prio, rate, body);
            this.hostContext.openDownlink((LinkBinding)downlink);
        } while (oldDownlinks != (newDownlinks = oldDownlinks.updated((Object)nodeUri, (Object)(nodeDownlinks = nodeDownlinks.updated((Object)laneUri, (Object)downlink)))) && !DOWNLINKS.compareAndSet(this, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>)oldDownlinks, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>)newDownlinks));
        if (oldDownlinks != newDownlinks) {
            downlink.openDown();
        }
        LinkAddressed resolvedEnvelope = envelope.nodeUri(nodeUri);
        downlink.queueUp((Envelope)resolvedEnvelope);
    }

    protected void routeUplink(LaneAddressed envelope) {
        HashTrieSet laneUplinks;
        Uri nodeUri = this.resolve(envelope.nodeUri());
        Uri laneUri = envelope.laneUri();
        HashTrieMap nodeUplinks = (HashTrieMap)this.uplinks.get((Object)nodeUri);
        if (nodeUplinks != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            LaneAddressed resolvedEnvelope = envelope.nodeUri(nodeUri);
            Iterator uplinksIterator = laneUplinks.iterator();
            while (uplinksIterator.hasNext()) {
                ((RemoteHostUplink)uplinksIterator.next()).queueDown((Envelope)resolvedEnvelope);
            }
        }
    }

    protected void onLinkRequest(LinkRequest request) {
        Policy policy = this.policy();
        if (policy != null) {
            PolicyDirective directive = policy.canLink(request, this.remoteIdentity);
            if (directive.isAllowed()) {
                LinkRequest newRequest = (LinkRequest)directive.get();
                if (newRequest != null) {
                    request = newRequest;
                }
            } else {
                if (directive.isDenied()) {
                    UnlinkedResponse response = new UnlinkedResponse(request.nodeUri(), request.laneUri());
                    this.warpSocketContext.feed((Envelope)response, 1.0f);
                    return;
                }
                this.forbid();
                return;
            }
        }
        this.routeDownlink((LinkAddressed)request);
    }

    protected void onLinkedResponse(LinkedResponse response) {
        this.routeUplink((LaneAddressed)response);
    }

    protected void onSyncRequest(SyncRequest request) {
        Policy policy = this.policy();
        if (policy != null) {
            PolicyDirective directive = policy.canSync(request, this.remoteIdentity);
            if (directive.isAllowed()) {
                SyncRequest newRequest = (SyncRequest)directive.get();
                if (newRequest != null) {
                    request = newRequest;
                }
            } else {
                if (directive.isDenied()) {
                    UnlinkedResponse response = new UnlinkedResponse(request.nodeUri(), request.laneUri());
                    this.warpSocketContext.feed((Envelope)response, 1.0f);
                    return;
                }
                this.forbid();
                return;
            }
        }
        this.routeDownlink((LinkAddressed)request);
    }

    protected void onSyncedResponse(SyncedResponse response) {
        this.routeUplink((LaneAddressed)response);
    }

    protected void onUnlinkRequest(UnlinkRequest request) {
        RemoteHostDownlink downlink;
        HashTrieMap newDownlinks;
        HashTrieMap oldDownlinks;
        Uri nodeUri = this.resolve(request.nodeUri());
        Uri laneUri = request.laneUri();
        do {
            HashTrieMap nodeDownlinks;
            if ((nodeDownlinks = (HashTrieMap)(oldDownlinks = this.downlinks).get((Object)nodeUri)) != null) {
                downlink = (RemoteHostDownlink)nodeDownlinks.get((Object)laneUri);
                if (downlink != null) {
                    if ((nodeDownlinks = nodeDownlinks.removed((Object)laneUri)).isEmpty()) {
                        newDownlinks = oldDownlinks.removed((Object)nodeUri);
                        continue;
                    }
                    newDownlinks = oldDownlinks.updated((Object)nodeUri, (Object)nodeDownlinks);
                    continue;
                }
                newDownlinks = oldDownlinks;
                break;
            }
            newDownlinks = oldDownlinks;
            downlink = null;
            break;
        } while (oldDownlinks != newDownlinks && !DOWNLINKS.compareAndSet(this, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>)oldDownlinks, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>)newDownlinks));
        if (downlink != null) {
            UnlinkRequest resolvedRequest = request.nodeUri(nodeUri);
            downlink.queueUp((Envelope)resolvedRequest);
        }
    }

    protected void onUnlinkedResponse(UnlinkedResponse response) {
        HashTrieSet laneUplinks;
        HashTrieMap newUplinks;
        HashTrieMap oldUplinks;
        Uri nodeUri = this.resolve(response.nodeUri());
        Uri laneUri = response.laneUri();
        do {
            HashTrieMap nodeUplinks;
            if ((nodeUplinks = (HashTrieMap)(oldUplinks = this.uplinks).get((Object)nodeUri)) != null) {
                laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri);
                if (laneUplinks != null) {
                    if ((nodeUplinks = nodeUplinks.removed((Object)laneUri)).isEmpty()) {
                        newUplinks = oldUplinks.removed((Object)nodeUri);
                        continue;
                    }
                    newUplinks = oldUplinks.updated((Object)nodeUri, (Object)nodeUplinks);
                    continue;
                }
                newUplinks = oldUplinks;
                break;
            }
            newUplinks = oldUplinks;
            laneUplinks = null;
            break;
        } while (oldUplinks != newUplinks && !UPLINKS.compareAndSet(this, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)newUplinks));
        if (laneUplinks != null) {
            UnlinkedResponse resolvedResponse = response.nodeUri(nodeUri);
            Iterator uplinksIterator = laneUplinks.iterator();
            while (uplinksIterator.hasNext()) {
                ((RemoteHostUplink)uplinksIterator.next()).queueDown((Envelope)resolvedResponse);
            }
        }
    }

    protected void onAuthRequest(AuthRequest request) {
        DeauthedResponse response;
        RemoteCredentials credentials = new RemoteCredentials(this.requestUri, this.remoteUri, request.body());
        PolicyDirective directive = this.hostContext.authenticate((Credentials)credentials);
        if (directive != null && directive.isAllowed()) {
            REMOTE_IDENTITY.set(this, (Identity)directive.get());
            response = new AuthedResponse();
            this.warpSocketContext.feed((Envelope)response, 1.0f);
        } else {
            response = new DeauthedResponse();
            this.warpSocketContext.feed((Envelope)response, 1.0f);
        }
        if (directive != null && directive.isForbidden()) {
            WarpSocketContext warpSocketContext = this.warpSocketContext;
            if (warpSocketContext != null) {
                warpSocketContext.write((WsControl)WsClose.from((int)1008, (String)"Unauthorized"));
            } else {
                this.close();
            }
        }
    }

    protected void onAuthedResponse(AuthedResponse response) {
    }

    protected void onDeauthRequest(DeauthRequest request) {
        REMOTE_IDENTITY.set(this, null);
        DeauthedResponse response = new DeauthedResponse();
        this.warpSocketContext.feed((Envelope)response, 1.0f);
    }

    protected void onDeauthedResponse(DeauthedResponse response) {
    }

    protected void onUnknownEnvelope(Envelope envelope) {
    }

    protected void forbid() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            warpSocketContext.write((WsControl)WsClose.from((int)1008, (String)"Forbidden"));
        } else {
            this.close();
        }
    }

    public void doWrite() {
    }

    public void didWrite(Envelope envelope) {
    }

    public void didWrite(WsControl<?, ?> frame) {
    }

    public void didTimeout() {
    }

    public void didDisconnect() {
        this.disconnectUplinks();
        this.hostContext.didDisconnect();
        this.reconnect();
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.hostContext.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.hostContext.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
        this.hostContext.closeDownlink(link);
    }

    public void httpDownlink(HttpBinding http) {
        this.hostContext.httpDownlink(http);
    }

    public void pushDown(PushRequest pushRequest) {
        this.hostContext.pushDown(pushRequest);
    }

    protected void willOpen() {
    }

    protected void didOpen() {
    }

    protected void willLoad() {
    }

    protected void didLoad() {
    }

    protected void willStart() {
    }

    protected void didStart() {
    }

    protected void willStop() {
    }

    protected void didStop() {
    }

    protected void willUnload() {
    }

    protected void didUnload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void willClose() {
        try {
            this.closeDownlinks();
        }
        finally {
            try {
                this.closeUplinks();
            }
            finally {
                try {
                    HostContext hostContext = this.hostContext;
                    if (hostContext != null) {
                        hostContext.close();
                    }
                }
                finally {
                    WarpSocketContext warpSocketContext = this.warpSocketContext;
                    if (warpSocketContext != null) {
                        warpSocketContext.close();
                    }
                }
            }
        }
    }

    public void didFail(Throwable error) {
        error.printStackTrace();
        this.warpSocketContext.write((WsControl)WsClose.from((int)1002, (String)error.getMessage()));
        this.hostContext.close();
    }

    protected void reconnect() {
        this.close();
    }

    protected void closeDownlinks() {
        HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>> oldDownlinks;
        HashTrieMap newDownlinks = HashTrieMap.empty();
        while ((oldDownlinks = this.downlinks) != newDownlinks && !DOWNLINKS.compareAndSet(this, oldDownlinks, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteHostDownlink>>)newDownlinks)) {
        }
        Iterator nodeDownlinksIterator = oldDownlinks.valueIterator();
        while (nodeDownlinksIterator.hasNext()) {
            HashTrieMap nodeDownlinks = (HashTrieMap)nodeDownlinksIterator.next();
            Iterator laneDownlinks = nodeDownlinks.valueIterator();
            while (laneDownlinks.hasNext()) {
                RemoteHostDownlink downlink = (RemoteHostDownlink)laneDownlinks.next();
                downlink.closeDown();
            }
        }
    }

    protected void closeUplinks() {
        HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>> oldUplinks;
        HashTrieMap newUplinks = HashTrieMap.empty();
        while ((oldUplinks = this.uplinks) != newUplinks && !UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteHostUplink>>>)newUplinks)) {
        }
        Iterator nodeUplinksIterator = this.uplinks.valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteHostUplink uplink : laneUplinks) {
                    uplink.closeUp();
                }
            }
        }
    }

    protected void connectUplinks() {
        Iterator nodeUplinksIterator = this.uplinks.valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteHostUplink uplink : laneUplinks) {
                    uplink.didConnect();
                }
            }
        }
    }

    protected void disconnectUplinks() {
        Iterator nodeUplinksIterator = this.uplinks.valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteHostUplink uplink : laneUplinks) {
                    uplink.didDisconnect();
                }
            }
        }
    }

    public void trace(Object message) {
        this.hostContext.trace(message);
    }

    public void debug(Object message) {
        this.hostContext.debug(message);
    }

    public void info(Object message) {
        this.hostContext.info(message);
    }

    public void warn(Object message) {
        this.hostContext.warn(message);
    }

    public void error(Object message) {
        this.hostContext.error(message);
    }

    static {
        int uriResolutionCacheSize;
        FLAGS = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "flags");
        REMOTE_IDENTITY = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, Identity.class, "remoteIdentity");
        DOWNLINKS = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, HashTrieMap.class, "downlinks");
        UPLINKS = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, HashTrieMap.class, "uplinks");
        try {
            uriResolutionCacheSize = Integer.parseInt(System.getProperty("swim.remote.uri.resolution.cache.size"));
        }
        catch (NumberFormatException e) {
            uriResolutionCacheSize = 8;
        }
        URI_RESOLUTION_CACHE_SIZE = uriResolutionCacheSize;
    }
}

